<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_CancelRQ StructType
 * Meta information extracted from the WSDL
 * - type: tns:OTA_CancelRQ
 * @subpackage Structs
 */
class OTA_CancelRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\POS
     */
    public $POS;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UniqueID[]
     */
    public $UniqueID;
    /**
     * The Verification
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Verification
     */
    public $Verification;
    /**
     * The CancelType
     * @var string
     */
    public $CancelType;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * Constructor method for OTA_CancelRQ
     * @uses OTA_CancelRQ::setPOS()
     * @uses OTA_CancelRQ::setUniqueID()
     * @uses OTA_CancelRQ::setVerification()
     * @uses OTA_CancelRQ::setCancelType()
     * @uses OTA_CancelRQ::setEchoToken()
     * @uses OTA_CancelRQ::setSequenceNmbr()
     * @uses OTA_CancelRQ::setTarget()
     * @uses OTA_CancelRQ::setTimeStamp()
     * @uses OTA_CancelRQ::setTransactionIdentifier()
     * @uses OTA_CancelRQ::setTransactionStatusCode()
     * @uses OTA_CancelRQ::setVersion()
     * @param \StructType\POS $pOS
     * @param \StructType\UniqueID[] $uniqueID
     * @param \StructType\Verification $verification
     * @param string $cancelType
     * @param string $echoToken
     * @param int $sequenceNmbr
     * @param string $target
     * @param string $timeStamp
     * @param string $transactionIdentifier
     * @param string $transactionStatusCode
     * @param string $version
     */
    public function __construct(\StructType\POS $pOS = null, array $uniqueID = array(), \StructType\Verification $verification = null, $cancelType = null, $echoToken = null, $sequenceNmbr = null, $target = null, $timeStamp = null, $transactionIdentifier = null, $transactionStatusCode = null, $version = null)
    {
        $this
            ->setPOS($pOS)
            ->setUniqueID($uniqueID)
            ->setVerification($verification)
            ->setCancelType($cancelType)
            ->setEchoToken($echoToken)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTarget($target)
            ->setTimeStamp($timeStamp)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setVersion($version);
    }
    /**
     * Get POS value
     * @return \StructType\POS|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS $pOS
     * @return \StructType\OTA_CancelRQ
     */
    public function setPOS(\StructType\POS $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oTA_CancelRQUniqueIDItem) {
            // validation for constraint: itemType
            if (!$oTA_CancelRQUniqueIDItem instanceof \StructType\UniqueID) {
                $invalidValues[] = is_object($oTA_CancelRQUniqueIDItem) ? get_class($oTA_CancelRQUniqueIDItem) : sprintf('%s(%s)', gettype($oTA_CancelRQUniqueIDItem), var_export($oTA_CancelRQUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \StructType\UniqueID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID[] $uniqueID
     * @return \StructType\OTA_CancelRQ
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID $item
     * @return \StructType\OTA_CancelRQ
     */
    public function addToUniqueID(\StructType\UniqueID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \StructType\UniqueID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get Verification value
     * @return \StructType\Verification|null
     */
    public function getVerification()
    {
        return $this->Verification;
    }
    /**
     * Set Verification value
     * @param \StructType\Verification $verification
     * @return \StructType\OTA_CancelRQ
     */
    public function setVerification(\StructType\Verification $verification = null)
    {
        $this->Verification = $verification;
        return $this;
    }
    /**
     * Get CancelType value
     * @return string|null
     */
    public function getCancelType()
    {
        return $this->CancelType;
    }
    /**
     * Set CancelType value
     * @param string $cancelType
     * @return \StructType\OTA_CancelRQ
     */
    public function setCancelType($cancelType = null)
    {
        // validation for constraint: string
        if (!is_null($cancelType) && !is_string($cancelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelType, true), gettype($cancelType)), __LINE__);
        }
        $this->CancelType = $cancelType;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_CancelRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_CancelRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !(is_int($sequenceNmbr) || ctype_digit($sequenceNmbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNmbr, true), gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_CancelRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_CancelRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_CancelRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_CancelRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatusCode, true), gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\OTA_CancelRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_CancelRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
