<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryItem StructType
 * @subpackage Structs
 */
class ItineraryItem extends AbstractStructBase
{
    /**
     * The Accommodation
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Accommodation
     */
    public $Accommodation;
    /**
     * The Flights
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Flights
     */
    public $Flights;
    /**
     * The RentalCar
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RentalCar
     */
    public $RentalCar;
    /**
     * The Travel
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Travel
     */
    public $Travel;
    /**
     * Constructor method for ItineraryItem
     * @uses ItineraryItem::setAccommodation()
     * @uses ItineraryItem::setFlights()
     * @uses ItineraryItem::setRentalCar()
     * @uses ItineraryItem::setTravel()
     * @param \StructType\Accommodation $accommodation
     * @param \StructType\Flights $flights
     * @param \StructType\RentalCar $rentalCar
     * @param \StructType\Travel $travel
     */
    public function __construct(\StructType\Accommodation $accommodation = null, \StructType\Flights $flights = null, \StructType\RentalCar $rentalCar = null, \StructType\Travel $travel = null)
    {
        $this
            ->setAccommodation($accommodation)
            ->setFlights($flights)
            ->setRentalCar($rentalCar)
            ->setTravel($travel);
    }
    /**
     * Get Accommodation value
     * @return \StructType\Accommodation|null
     */
    public function getAccommodation()
    {
        return $this->Accommodation;
    }
    /**
     * Set Accommodation value
     * @param \StructType\Accommodation $accommodation
     * @return \StructType\ItineraryItem
     */
    public function setAccommodation(\StructType\Accommodation $accommodation = null)
    {
        $this->Accommodation = $accommodation;
        return $this;
    }
    /**
     * Get Flights value
     * @return \StructType\Flights|null
     */
    public function getFlights()
    {
        return $this->Flights;
    }
    /**
     * Set Flights value
     * @param \StructType\Flights $flights
     * @return \StructType\ItineraryItem
     */
    public function setFlights(\StructType\Flights $flights = null)
    {
        $this->Flights = $flights;
        return $this;
    }
    /**
     * Get RentalCar value
     * @return \StructType\RentalCar|null
     */
    public function getRentalCar()
    {
        return $this->RentalCar;
    }
    /**
     * Set RentalCar value
     * @param \StructType\RentalCar $rentalCar
     * @return \StructType\ItineraryItem
     */
    public function setRentalCar(\StructType\RentalCar $rentalCar = null)
    {
        $this->RentalCar = $rentalCar;
        return $this;
    }
    /**
     * Get Travel value
     * @return \StructType\Travel|null
     */
    public function getTravel()
    {
        return $this->Travel;
    }
    /**
     * Set Travel value
     * @param \StructType\Travel $travel
     * @return \StructType\ItineraryItem
     */
    public function setTravel(\StructType\Travel $travel = null)
    {
        $this->Travel = $travel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItineraryItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
