<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearchCriteria StructType
 * @subpackage Structs
 */
class HotelSearchCriteria extends AbstractStructBase
{
    /**
     * The Criterion
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Criterion[]
     */
    public $Criterion;
    /**
     * Constructor method for HotelSearchCriteria
     * @uses HotelSearchCriteria::setCriterion()
     * @param \StructType\Criterion[] $criterion
     */
    public function __construct(array $criterion = array())
    {
        $this
            ->setCriterion($criterion);
    }
    /**
     * Get Criterion value
     * @return \StructType\Criterion[]|null
     */
    public function getCriterion()
    {
        return $this->Criterion;
    }
    /**
     * This method is responsible for validating the values passed to the setCriterion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriterion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCriterionForArrayConstraintsFromSetCriterion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriteriaCriterionItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriteriaCriterionItem instanceof \StructType\Criterion) {
                $invalidValues[] = is_object($hotelSearchCriteriaCriterionItem) ? get_class($hotelSearchCriteriaCriterionItem) : sprintf('%s(%s)', gettype($hotelSearchCriteriaCriterionItem), var_export($hotelSearchCriteriaCriterionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Criterion property can only contain items of type \StructType\Criterion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Criterion value
     * @throws \InvalidArgumentException
     * @param \StructType\Criterion[] $criterion
     * @return \StructType\HotelSearchCriteria
     */
    public function setCriterion(array $criterion = array())
    {
        // validation for constraint: array
        if ('' !== ($criterionArrayErrorMessage = self::validateCriterionForArrayConstraintsFromSetCriterion($criterion))) {
            throw new \InvalidArgumentException($criterionArrayErrorMessage, __LINE__);
        }
        $this->Criterion = $criterion;
        return $this;
    }
    /**
     * Add item to Criterion value
     * @throws \InvalidArgumentException
     * @param \StructType\Criterion $item
     * @return \StructType\HotelSearchCriteria
     */
    public function addToCriterion(\StructType\Criterion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Criterion) {
            throw new \InvalidArgumentException(sprintf('The Criterion property can only contain items of type \StructType\Criterion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Criterion[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelSearchCriteria
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
