<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservationIDs StructType
 * @subpackage Structs
 */
class HotelReservationIDs extends AbstractStructBase
{
    /**
     * The HotelReservationID
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelReservationID[]
     */
    public $HotelReservationID;
    /**
     * Constructor method for HotelReservationIDs
     * @uses HotelReservationIDs::setHotelReservationID()
     * @param \StructType\HotelReservationID[] $hotelReservationID
     */
    public function __construct(array $hotelReservationID = array())
    {
        $this
            ->setHotelReservationID($hotelReservationID);
    }
    /**
     * Get HotelReservationID value
     * @return \StructType\HotelReservationID[]|null
     */
    public function getHotelReservationID()
    {
        return $this->HotelReservationID;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelReservationID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelReservationID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelReservationIDForArrayConstraintsFromSetHotelReservationID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelReservationIDsHotelReservationIDItem) {
            // validation for constraint: itemType
            if (!$hotelReservationIDsHotelReservationIDItem instanceof \StructType\HotelReservationID) {
                $invalidValues[] = is_object($hotelReservationIDsHotelReservationIDItem) ? get_class($hotelReservationIDsHotelReservationIDItem) : sprintf('%s(%s)', gettype($hotelReservationIDsHotelReservationIDItem), var_export($hotelReservationIDsHotelReservationIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelReservationID property can only contain items of type \StructType\HotelReservationID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelReservationID value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReservationID[] $hotelReservationID
     * @return \StructType\HotelReservationIDs
     */
    public function setHotelReservationID(array $hotelReservationID = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelReservationIDArrayErrorMessage = self::validateHotelReservationIDForArrayConstraintsFromSetHotelReservationID($hotelReservationID))) {
            throw new \InvalidArgumentException($hotelReservationIDArrayErrorMessage, __LINE__);
        }
        $this->HotelReservationID = $hotelReservationID;
        return $this;
    }
    /**
     * Add item to HotelReservationID value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReservationID $item
     * @return \StructType\HotelReservationIDs
     */
    public function addToHotelReservationID(\StructType\HotelReservationID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelReservationID) {
            throw new \InvalidArgumentException(sprintf('The HotelReservationID property can only contain items of type \StructType\HotelReservationID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelReservationID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelReservationIDs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
