<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservationID StructType
 * @subpackage Structs
 */
class HotelReservationID extends AbstractStructBase
{
    /**
     * The ResID_Date
     * @var string
     */
    public $ResID_Date;
    /**
     * The ResID_Source
     * @var string
     */
    public $ResID_Source;
    /**
     * The ResID_Type
     * @var int
     */
    public $ResID_Type;
    /**
     * The ResID_Value
     * @var string
     */
    public $ResID_Value;
    /**
     * Constructor method for HotelReservationID
     * @uses HotelReservationID::setResID_Date()
     * @uses HotelReservationID::setResID_Source()
     * @uses HotelReservationID::setResID_Type()
     * @uses HotelReservationID::setResID_Value()
     * @param string $resID_Date
     * @param string $resID_Source
     * @param int $resID_Type
     * @param string $resID_Value
     */
    public function __construct($resID_Date = null, $resID_Source = null, $resID_Type = null, $resID_Value = null)
    {
        $this
            ->setResID_Date($resID_Date)
            ->setResID_Source($resID_Source)
            ->setResID_Type($resID_Type)
            ->setResID_Value($resID_Value);
    }
    /**
     * Get ResID_Date value
     * @return string|null
     */
    public function getResID_Date()
    {
        return $this->ResID_Date;
    }
    /**
     * Set ResID_Date value
     * @param string $resID_Date
     * @return \StructType\HotelReservationID
     */
    public function setResID_Date($resID_Date = null)
    {
        // validation for constraint: string
        if (!is_null($resID_Date) && !is_string($resID_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resID_Date, true), gettype($resID_Date)), __LINE__);
        }
        $this->ResID_Date = $resID_Date;
        return $this;
    }
    /**
     * Get ResID_Source value
     * @return string|null
     */
    public function getResID_Source()
    {
        return $this->ResID_Source;
    }
    /**
     * Set ResID_Source value
     * @param string $resID_Source
     * @return \StructType\HotelReservationID
     */
    public function setResID_Source($resID_Source = null)
    {
        // validation for constraint: string
        if (!is_null($resID_Source) && !is_string($resID_Source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resID_Source, true), gettype($resID_Source)), __LINE__);
        }
        $this->ResID_Source = $resID_Source;
        return $this;
    }
    /**
     * Get ResID_Type value
     * @return int|null
     */
    public function getResID_Type()
    {
        return $this->ResID_Type;
    }
    /**
     * Set ResID_Type value
     * @param int $resID_Type
     * @return \StructType\HotelReservationID
     */
    public function setResID_Type($resID_Type = null)
    {
        // validation for constraint: int
        if (!is_null($resID_Type) && !(is_int($resID_Type) || ctype_digit($resID_Type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resID_Type, true), gettype($resID_Type)), __LINE__);
        }
        $this->ResID_Type = $resID_Type;
        return $this;
    }
    /**
     * Get ResID_Value value
     * @return string|null
     */
    public function getResID_Value()
    {
        return $this->ResID_Value;
    }
    /**
     * Set ResID_Value value
     * @param string $resID_Value
     * @return \StructType\HotelReservationID
     */
    public function setResID_Value($resID_Value = null)
    {
        // validation for constraint: string
        if (!is_null($resID_Value) && !is_string($resID_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resID_Value, true), gettype($resID_Value)), __LINE__);
        }
        $this->ResID_Value = $resID_Value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelReservationID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
