<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservation StructType
 * Meta information extracted from the WSDL
 * - type: tns:HotelReservation
 * @subpackage Structs
 */
class HotelReservation extends AbstractStructBase
{
    /**
     * The RoomStays
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RoomStays
     */
    public $RoomStays;
    /**
     * The ResGuests
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\ResGuests
     */
    public $ResGuests;
    /**
     * The ResGlobalInfo
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\ResGlobalInfo
     */
    public $ResGlobalInfo;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UniqueID
     */
    public $UniqueID;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * @var string
     */
    public $CreatorID;
    /**
     * The ResStatus
     * @var string
     */
    public $ResStatus;
    /**
     * The RoomStayReservation
     * @var bool
     */
    public $RoomStayReservation;
    /**
     * Constructor method for HotelReservation
     * @uses HotelReservation::setRoomStays()
     * @uses HotelReservation::setResGuests()
     * @uses HotelReservation::setResGlobalInfo()
     * @uses HotelReservation::setUniqueID()
     * @uses HotelReservation::setCreateDateTime()
     * @uses HotelReservation::setCreatorID()
     * @uses HotelReservation::setResStatus()
     * @uses HotelReservation::setRoomStayReservation()
     * @param \StructType\RoomStays $roomStays
     * @param \StructType\ResGuests $resGuests
     * @param \StructType\ResGlobalInfo $resGlobalInfo
     * @param \StructType\UniqueID $uniqueID
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $resStatus
     * @param bool $roomStayReservation
     */
    public function __construct(\StructType\RoomStays $roomStays = null, \StructType\ResGuests $resGuests = null, \StructType\ResGlobalInfo $resGlobalInfo = null, \StructType\UniqueID $uniqueID = null, $createDateTime = null, $creatorID = null, $resStatus = null, $roomStayReservation = null)
    {
        $this
            ->setRoomStays($roomStays)
            ->setResGuests($resGuests)
            ->setResGlobalInfo($resGlobalInfo)
            ->setUniqueID($uniqueID)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setResStatus($resStatus)
            ->setRoomStayReservation($roomStayReservation);
    }
    /**
     * Get RoomStays value
     * @return \StructType\RoomStays|null
     */
    public function getRoomStays()
    {
        return $this->RoomStays;
    }
    /**
     * Set RoomStays value
     * @param \StructType\RoomStays $roomStays
     * @return \StructType\HotelReservation
     */
    public function setRoomStays(\StructType\RoomStays $roomStays = null)
    {
        $this->RoomStays = $roomStays;
        return $this;
    }
    /**
     * Get ResGuests value
     * @return \StructType\ResGuests|null
     */
    public function getResGuests()
    {
        return $this->ResGuests;
    }
    /**
     * Set ResGuests value
     * @param \StructType\ResGuests $resGuests
     * @return \StructType\HotelReservation
     */
    public function setResGuests(\StructType\ResGuests $resGuests = null)
    {
        $this->ResGuests = $resGuests;
        return $this;
    }
    /**
     * Get ResGlobalInfo value
     * @return \StructType\ResGlobalInfo|null
     */
    public function getResGlobalInfo()
    {
        return $this->ResGlobalInfo;
    }
    /**
     * Set ResGlobalInfo value
     * @param \StructType\ResGlobalInfo $resGlobalInfo
     * @return \StructType\HotelReservation
     */
    public function setResGlobalInfo(\StructType\ResGlobalInfo $resGlobalInfo = null)
    {
        $this->ResGlobalInfo = $resGlobalInfo;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID $uniqueID
     * @return \StructType\HotelReservation
     */
    public function setUniqueID(\StructType\UniqueID $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\HotelReservation
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \StructType\HotelReservation
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorID, true), gettype($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @param string $resStatus
     * @return \StructType\HotelReservation
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: string
        if (!is_null($resStatus) && !is_string($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resStatus, true), gettype($resStatus)), __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
    /**
     * Get RoomStayReservation value
     * @return bool|null
     */
    public function getRoomStayReservation()
    {
        return $this->RoomStayReservation;
    }
    /**
     * Set RoomStayReservation value
     * @param bool $roomStayReservation
     * @return \StructType\HotelReservation
     */
    public function setRoomStayReservation($roomStayReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($roomStayReservation) && !is_bool($roomStayReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($roomStayReservation, true), gettype($roomStayReservation)), __LINE__);
        }
        $this->RoomStayReservation = $roomStayReservation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
