<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Flights StructType
 * @subpackage Structs
 */
class Flights extends AbstractStructBase
{
    /**
     * The Flight
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Flight[]
     */
    public $Flight;
    /**
     * The SupplementCharges
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\SupplementCharges
     */
    public $SupplementCharges;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - ref: tns:Code
     * @var string
     */
    public $Code;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Flights
     * @uses Flights::setFlight()
     * @uses Flights::setSupplementCharges()
     * @uses Flights::setCode()
     * @uses Flights::setStatus()
     * @param \StructType\Flight[] $flight
     * @param \StructType\SupplementCharges $supplementCharges
     * @param string $code
     * @param string $status
     */
    public function __construct(array $flight = array(), \StructType\SupplementCharges $supplementCharges = null, $code = null, $status = null)
    {
        $this
            ->setFlight($flight)
            ->setSupplementCharges($supplementCharges)
            ->setCode($code)
            ->setStatus($status);
    }
    /**
     * Get Flight value
     * @return \StructType\Flight[]|null
     */
    public function getFlight()
    {
        return $this->Flight;
    }
    /**
     * This method is responsible for validating the values passed to the setFlight method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlight method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightForArrayConstraintsFromSetFlight(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightsFlightItem) {
            // validation for constraint: itemType
            if (!$flightsFlightItem instanceof \StructType\Flight) {
                $invalidValues[] = is_object($flightsFlightItem) ? get_class($flightsFlightItem) : sprintf('%s(%s)', gettype($flightsFlightItem), var_export($flightsFlightItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Flight property can only contain items of type \StructType\Flight, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Flight value
     * @throws \InvalidArgumentException
     * @param \StructType\Flight[] $flight
     * @return \StructType\Flights
     */
    public function setFlight(array $flight = array())
    {
        // validation for constraint: array
        if ('' !== ($flightArrayErrorMessage = self::validateFlightForArrayConstraintsFromSetFlight($flight))) {
            throw new \InvalidArgumentException($flightArrayErrorMessage, __LINE__);
        }
        $this->Flight = $flight;
        return $this;
    }
    /**
     * Add item to Flight value
     * @throws \InvalidArgumentException
     * @param \StructType\Flight $item
     * @return \StructType\Flights
     */
    public function addToFlight(\StructType\Flight $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Flight) {
            throw new \InvalidArgumentException(sprintf('The Flight property can only contain items of type \StructType\Flight, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Flight[] = $item;
        return $this;
    }
    /**
     * Get SupplementCharges value
     * @return \StructType\SupplementCharges|null
     */
    public function getSupplementCharges()
    {
        return $this->SupplementCharges;
    }
    /**
     * Set SupplementCharges value
     * @param \StructType\SupplementCharges $supplementCharges
     * @return \StructType\Flights
     */
    public function setSupplementCharges(\StructType\SupplementCharges $supplementCharges = null)
    {
        $this->SupplementCharges = $supplementCharges;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Flights
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\Flights
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Flights
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
