<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Flight StructType
 * @subpackage Structs
 */
class Flight extends AbstractStructBase
{
    /**
     * The ArrivalAirport
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\ArrivalAirport
     */
    public $ArrivalAirport;
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\DepartureAirport
     */
    public $DepartureAirport;
    /**
     * The Equipment
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Equipment
     */
    public $Equipment;
    /**
     * The OperatingAirline
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\OperatingAirline
     */
    public $OperatingAirline;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - ref: tns:ArrivalDateTime
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - ref: tns:DepartureDateTime
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - ref: tns:Duration
     * @var string
     */
    public $Duration;
    /**
     * The NumberOfStops
     * Meta information extracted from the WSDL
     * - ref: tns:NumberOfStops
     * @var string
     */
    public $NumberOfStops;
    /**
     * Constructor method for Flight
     * @uses Flight::setArrivalAirport()
     * @uses Flight::setDepartureAirport()
     * @uses Flight::setEquipment()
     * @uses Flight::setOperatingAirline()
     * @uses Flight::setArrivalDateTime()
     * @uses Flight::setDepartureDateTime()
     * @uses Flight::setDuration()
     * @uses Flight::setNumberOfStops()
     * @param \StructType\ArrivalAirport $arrivalAirport
     * @param \StructType\DepartureAirport $departureAirport
     * @param \StructType\Equipment $equipment
     * @param \StructType\OperatingAirline $operatingAirline
     * @param string $arrivalDateTime
     * @param string $departureDateTime
     * @param string $duration
     * @param string $numberOfStops
     */
    public function __construct(\StructType\ArrivalAirport $arrivalAirport = null, \StructType\DepartureAirport $departureAirport = null, \StructType\Equipment $equipment = null, \StructType\OperatingAirline $operatingAirline = null, $arrivalDateTime = null, $departureDateTime = null, $duration = null, $numberOfStops = null)
    {
        $this
            ->setArrivalAirport($arrivalAirport)
            ->setDepartureAirport($departureAirport)
            ->setEquipment($equipment)
            ->setOperatingAirline($operatingAirline)
            ->setArrivalDateTime($arrivalDateTime)
            ->setDepartureDateTime($departureDateTime)
            ->setDuration($duration)
            ->setNumberOfStops($numberOfStops);
    }
    /**
     * Get ArrivalAirport value
     * @return \StructType\ArrivalAirport|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \StructType\ArrivalAirport $arrivalAirport
     * @return \StructType\Flight
     */
    public function setArrivalAirport(\StructType\ArrivalAirport $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \StructType\DepartureAirport|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \StructType\DepartureAirport $departureAirport
     * @return \StructType\Flight
     */
    public function setDepartureAirport(\StructType\DepartureAirport $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \StructType\Equipment|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \StructType\Equipment $equipment
     * @return \StructType\Flight
     */
    public function setEquipment(\StructType\Equipment $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return \StructType\OperatingAirline|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @param \StructType\OperatingAirline $operatingAirline
     * @return \StructType\Flight
     */
    public function setOperatingAirline(\StructType\OperatingAirline $operatingAirline = null)
    {
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\Flight
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \StructType\Flight
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\Flight
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get NumberOfStops value
     * @return string|null
     */
    public function getNumberOfStops()
    {
        return $this->NumberOfStops;
    }
    /**
     * Set NumberOfStops value
     * @param string $numberOfStops
     * @return \StructType\Flight
     */
    public function setNumberOfStops($numberOfStops = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfStops) && !is_string($numberOfStops)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberOfStops, true), gettype($numberOfStops)), __LINE__);
        }
        $this->NumberOfStops = $numberOfStops;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Flight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
