<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Feature StructType
 * @subpackage Structs
 */
class Feature extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Description
     */
    public $Description;
    /**
     * The RoomAmenity
     * @var string
     */
    public $RoomAmenity;
    /**
     * Constructor method for Feature
     * @uses Feature::setDescription()
     * @uses Feature::setRoomAmenity()
     * @param \StructType\Description $description
     * @param string $roomAmenity
     */
    public function __construct(\StructType\Description $description = null, $roomAmenity = null)
    {
        $this
            ->setDescription($description)
            ->setRoomAmenity($roomAmenity);
    }
    /**
     * Get Description value
     * @return \StructType\Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Description $description
     * @return \StructType\Feature
     */
    public function setDescription(\StructType\Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get RoomAmenity value
     * @return string|null
     */
    public function getRoomAmenity()
    {
        return $this->RoomAmenity;
    }
    /**
     * Set RoomAmenity value
     * @param string $roomAmenity
     * @return \StructType\Feature
     */
    public function setRoomAmenity($roomAmenity = null)
    {
        // validation for constraint: string
        if (!is_null($roomAmenity) && !is_string($roomAmenity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomAmenity, true), gettype($roomAmenity)), __LINE__);
        }
        $this->RoomAmenity = $roomAmenity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Feature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
