<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Equipment StructType
 * @subpackage Structs
 */
class Equipment extends AbstractStructBase
{
    /**
     * The AirEquipType
     * Meta information extracted from the WSDL
     * - ref: tns:AirEquipType
     * @var string
     */
    public $AirEquipType;
    /**
     * Constructor method for Equipment
     * @uses Equipment::setAirEquipType()
     * @param string $airEquipType
     */
    public function __construct($airEquipType = null)
    {
        $this
            ->setAirEquipType($airEquipType);
    }
    /**
     * Get AirEquipType value
     * @return string|null
     */
    public function getAirEquipType()
    {
        return $this->AirEquipType;
    }
    /**
     * Set AirEquipType value
     * @param string $airEquipType
     * @return \StructType\Equipment
     */
    public function setAirEquipType($airEquipType = null)
    {
        // validation for constraint: string
        if (!is_null($airEquipType) && !is_string($airEquipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airEquipType, true), gettype($airEquipType)), __LINE__);
        }
        $this->AirEquipType = $airEquipType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Equipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
