<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectBill StructType
 * @subpackage Structs
 */
class DirectBill extends AbstractStructBase
{
    /**
     * The DirectBill_ID
     * @var string
     */
    public $DirectBill_ID;
    /**
     * Constructor method for DirectBill
     * @uses DirectBill::setDirectBill_ID()
     * @param string $directBill_ID
     */
    public function __construct($directBill_ID = null)
    {
        $this
            ->setDirectBill_ID($directBill_ID);
    }
    /**
     * Get DirectBill_ID value
     * @return string|null
     */
    public function getDirectBill_ID()
    {
        return $this->DirectBill_ID;
    }
    /**
     * Set DirectBill_ID value
     * @param string $directBill_ID
     * @return \StructType\DirectBill
     */
    public function setDirectBill_ID($directBill_ID = null)
    {
        // validation for constraint: string
        if (!is_null($directBill_ID) && !is_string($directBill_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directBill_ID, true), gettype($directBill_ID)), __LINE__);
        }
        $this->DirectBill_ID = $directBill_ID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DirectBill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
