<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerLoyaltyProgram StructType
 * @subpackage Structs
 */
class CustomerLoyaltyProgram extends AbstractStructBase
{
    /**
     * The MembershipID
     * @var string
     */
    public $MembershipID;
    /**
     * The ProgramID
     * @var string
     */
    public $ProgramID;
    /**
     * Constructor method for customerLoyaltyProgram
     * @uses CustomerLoyaltyProgram::setMembershipID()
     * @uses CustomerLoyaltyProgram::setProgramID()
     * @param string $membershipID
     * @param string $programID
     */
    public function __construct($membershipID = null, $programID = null)
    {
        $this
            ->setMembershipID($membershipID)
            ->setProgramID($programID);
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \StructType\CustomerLoyaltyProgram
     */
    public function setMembershipID($membershipID = null)
    {
        // validation for constraint: string
        if (!is_null($membershipID) && !is_string($membershipID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipID, true), gettype($membershipID)), __LINE__);
        }
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \StructType\CustomerLoyaltyProgram
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: string
        if (!is_null($programID) && !is_string($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programID, true), gettype($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerLoyaltyProgram
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
