<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\PersonName
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Telephone
     */
    public $Telephone;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Primary
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Primary
     */
    public $Primary;
    /**
     * The PaymentForm
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\PaymentForm
     */
    public $PaymentForm;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for Customer
     * @uses Customer::setPersonName()
     * @uses Customer::setTelephone()
     * @uses Customer::setAddress()
     * @uses Customer::setPrimary()
     * @uses Customer::setPaymentForm()
     * @uses Customer::setEmail()
     * @uses Customer::setCurrencyCode()
     * @param \StructType\PersonName $personName
     * @param \StructType\Telephone $telephone
     * @param \StructType\Address $address
     * @param \StructType\Primary $primary
     * @param \StructType\PaymentForm $paymentForm
     * @param string $email
     * @param string $currencyCode
     */
    public function __construct(\StructType\PersonName $personName = null, \StructType\Telephone $telephone = null, \StructType\Address $address = null, \StructType\Primary $primary = null, \StructType\PaymentForm $paymentForm = null, $email = null, $currencyCode = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setAddress($address)
            ->setPrimary($primary)
            ->setPaymentForm($paymentForm)
            ->setEmail($email)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get PersonName value
     * @return \StructType\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \StructType\PersonName $personName
     * @return \StructType\Customer
     */
    public function setPersonName(\StructType\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \StructType\Telephone $telephone
     * @return \StructType\Customer
     */
    public function setTelephone(\StructType\Telephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\Customer
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Primary value
     * @return \StructType\Primary|null
     */
    public function getPrimary()
    {
        return $this->Primary;
    }
    /**
     * Set Primary value
     * @param \StructType\Primary $primary
     * @return \StructType\Customer
     */
    public function setPrimary(\StructType\Primary $primary = null)
    {
        $this->Primary = $primary;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \StructType\PaymentForm|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * Set PaymentForm value
     * @param \StructType\PaymentForm $paymentForm
     * @return \StructType\Customer
     */
    public function setPaymentForm(\StructType\PaymentForm $paymentForm = null)
    {
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Customer
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\Customer
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
