<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactNumbers StructType
 * @subpackage Structs
 */
class ContactNumbers extends AbstractStructBase
{
    /**
     * The ContactNumber
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactNumber[]
     */
    public $ContactNumber;
    /**
     * Constructor method for ContactNumbers
     * @uses ContactNumbers::setContactNumber()
     * @param \StructType\ContactNumber[] $contactNumber
     */
    public function __construct(array $contactNumber = array())
    {
        $this
            ->setContactNumber($contactNumber);
    }
    /**
     * Get ContactNumber value
     * @return \StructType\ContactNumber[]|null
     */
    public function getContactNumber()
    {
        return $this->ContactNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setContactNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactNumberForArrayConstraintsFromSetContactNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactNumbersContactNumberItem) {
            // validation for constraint: itemType
            if (!$contactNumbersContactNumberItem instanceof \StructType\ContactNumber) {
                $invalidValues[] = is_object($contactNumbersContactNumberItem) ? get_class($contactNumbersContactNumberItem) : sprintf('%s(%s)', gettype($contactNumbersContactNumberItem), var_export($contactNumbersContactNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactNumber property can only contain items of type \StructType\ContactNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactNumber[] $contactNumber
     * @return \StructType\ContactNumbers
     */
    public function setContactNumber(array $contactNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($contactNumberArrayErrorMessage = self::validateContactNumberForArrayConstraintsFromSetContactNumber($contactNumber))) {
            throw new \InvalidArgumentException($contactNumberArrayErrorMessage, __LINE__);
        }
        $this->ContactNumber = $contactNumber;
        return $this;
    }
    /**
     * Add item to ContactNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactNumber $item
     * @return \StructType\ContactNumbers
     */
    public function addToContactNumber(\StructType\ContactNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactNumber) {
            throw new \InvalidArgumentException(sprintf('The ContactNumber property can only contain items of type \StructType\ContactNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactNumber[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactNumbers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
