<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPenalty StructType
 * @subpackage Structs
 */
class CancelPenalty extends AbstractStructBase
{
    /**
     * The AmountPercent
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\AmountPercent
     */
    public $AmountPercent;
    /**
     * The Deadline
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Deadline
     */
    public $Deadline;
    /**
     * The PenaltyDescription
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\PenaltyDescription
     */
    public $PenaltyDescription;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The PolicyCode
     * @var string
     */
    public $PolicyCode;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * Constructor method for CancelPenalty
     * @uses CancelPenalty::setAmountPercent()
     * @uses CancelPenalty::setDeadline()
     * @uses CancelPenalty::setPenaltyDescription()
     * @uses CancelPenalty::setDuration()
     * @uses CancelPenalty::setEnd()
     * @uses CancelPenalty::setPolicyCode()
     * @uses CancelPenalty::setRoomTypeCode()
     * @uses CancelPenalty::setStart()
     * @param \StructType\AmountPercent $amountPercent
     * @param \StructType\Deadline $deadline
     * @param \StructType\PenaltyDescription $penaltyDescription
     * @param string $duration
     * @param string $end
     * @param string $policyCode
     * @param string $roomTypeCode
     * @param string $start
     */
    public function __construct(\StructType\AmountPercent $amountPercent = null, \StructType\Deadline $deadline = null, \StructType\PenaltyDescription $penaltyDescription = null, $duration = null, $end = null, $policyCode = null, $roomTypeCode = null, $start = null)
    {
        $this
            ->setAmountPercent($amountPercent)
            ->setDeadline($deadline)
            ->setPenaltyDescription($penaltyDescription)
            ->setDuration($duration)
            ->setEnd($end)
            ->setPolicyCode($policyCode)
            ->setRoomTypeCode($roomTypeCode)
            ->setStart($start);
    }
    /**
     * Get AmountPercent value
     * @return \StructType\AmountPercent|null
     */
    public function getAmountPercent()
    {
        return $this->AmountPercent;
    }
    /**
     * Set AmountPercent value
     * @param \StructType\AmountPercent $amountPercent
     * @return \StructType\CancelPenalty
     */
    public function setAmountPercent(\StructType\AmountPercent $amountPercent = null)
    {
        $this->AmountPercent = $amountPercent;
        return $this;
    }
    /**
     * Get Deadline value
     * @return \StructType\Deadline|null
     */
    public function getDeadline()
    {
        return $this->Deadline;
    }
    /**
     * Set Deadline value
     * @param \StructType\Deadline $deadline
     * @return \StructType\CancelPenalty
     */
    public function setDeadline(\StructType\Deadline $deadline = null)
    {
        $this->Deadline = $deadline;
        return $this;
    }
    /**
     * Get PenaltyDescription value
     * @return \StructType\PenaltyDescription|null
     */
    public function getPenaltyDescription()
    {
        return $this->PenaltyDescription;
    }
    /**
     * Set PenaltyDescription value
     * @param \StructType\PenaltyDescription $penaltyDescription
     * @return \StructType\CancelPenalty
     */
    public function setPenaltyDescription(\StructType\PenaltyDescription $penaltyDescription = null)
    {
        $this->PenaltyDescription = $penaltyDescription;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\CancelPenalty
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\CancelPenalty
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get PolicyCode value
     * @return string|null
     */
    public function getPolicyCode()
    {
        return $this->PolicyCode;
    }
    /**
     * Set PolicyCode value
     * @param string $policyCode
     * @return \StructType\CancelPenalty
     */
    public function setPolicyCode($policyCode = null)
    {
        // validation for constraint: string
        if (!is_null($policyCode) && !is_string($policyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyCode, true), gettype($policyCode)), __LINE__);
        }
        $this->PolicyCode = $policyCode;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\CancelPenalty
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\CancelPenalty
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelPenalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
