<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasicPropertyInfo StructType
 * @subpackage Structs
 */
class BasicPropertyInfo extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Award
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Award
     */
    public $Award;
    /**
     * The ContactNumbers
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The VendorMessages
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\VendorMessages
     */
    public $VendorMessages;
    /**
     * The BrandCode
     * @var string
     */
    public $BrandCode;
    /**
     * The ChainCode
     * @var string
     */
    public $ChainCode;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCodeContext
     * @var string
     */
    public $HotelCodeContext;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * Constructor method for BasicPropertyInfo
     * @uses BasicPropertyInfo::setAddress()
     * @uses BasicPropertyInfo::setAward()
     * @uses BasicPropertyInfo::setContactNumbers()
     * @uses BasicPropertyInfo::setVendorMessages()
     * @uses BasicPropertyInfo::setBrandCode()
     * @uses BasicPropertyInfo::setChainCode()
     * @uses BasicPropertyInfo::setHotelCode()
     * @uses BasicPropertyInfo::setHotelCodeContext()
     * @uses BasicPropertyInfo::setHotelName()
     * @param \StructType\Address $address
     * @param \StructType\Award $award
     * @param \StructType\ContactNumbers $contactNumbers
     * @param \StructType\VendorMessages $vendorMessages
     * @param string $brandCode
     * @param string $chainCode
     * @param string $hotelCode
     * @param string $hotelCodeContext
     * @param string $hotelName
     */
    public function __construct(\StructType\Address $address = null, \StructType\Award $award = null, \StructType\ContactNumbers $contactNumbers = null, \StructType\VendorMessages $vendorMessages = null, $brandCode = null, $chainCode = null, $hotelCode = null, $hotelCodeContext = null, $hotelName = null)
    {
        $this
            ->setAddress($address)
            ->setAward($award)
            ->setContactNumbers($contactNumbers)
            ->setVendorMessages($vendorMessages)
            ->setBrandCode($brandCode)
            ->setChainCode($chainCode)
            ->setHotelCode($hotelCode)
            ->setHotelCodeContext($hotelCodeContext)
            ->setHotelName($hotelName);
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\BasicPropertyInfo
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Award value
     * @return \StructType\Award|null
     */
    public function getAward()
    {
        return $this->Award;
    }
    /**
     * Set Award value
     * @param \StructType\Award $award
     * @return \StructType\BasicPropertyInfo
     */
    public function setAward(\StructType\Award $award = null)
    {
        $this->Award = $award;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \StructType\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \StructType\ContactNumbers $contactNumbers
     * @return \StructType\BasicPropertyInfo
     */
    public function setContactNumbers(\StructType\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get VendorMessages value
     * @return \StructType\VendorMessages|null
     */
    public function getVendorMessages()
    {
        return $this->VendorMessages;
    }
    /**
     * Set VendorMessages value
     * @param \StructType\VendorMessages $vendorMessages
     * @return \StructType\BasicPropertyInfo
     */
    public function setVendorMessages(\StructType\VendorMessages $vendorMessages = null)
    {
        $this->VendorMessages = $vendorMessages;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \StructType\BasicPropertyInfo
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandCode, true), gettype($brandCode)), __LINE__);
        }
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \StructType\BasicPropertyInfo
     */
    public function setChainCode($chainCode = null)
    {
        // validation for constraint: string
        if (!is_null($chainCode) && !is_string($chainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainCode, true), gettype($chainCode)), __LINE__);
        }
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\BasicPropertyInfo
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCodeContext value
     * @return string|null
     */
    public function getHotelCodeContext()
    {
        return $this->HotelCodeContext;
    }
    /**
     * Set HotelCodeContext value
     * @param string $hotelCodeContext
     * @return \StructType\BasicPropertyInfo
     */
    public function setHotelCodeContext($hotelCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeContext) && !is_string($hotelCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCodeContext, true), gettype($hotelCodeContext)), __LINE__);
        }
        $this->HotelCodeContext = $hotelCodeContext;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\BasicPropertyInfo
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BasicPropertyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
