<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailRequestSegment StructType
 * @subpackage Structs
 */
class AvailRequestSegment extends AbstractStructBase
{
    /**
     * The StayDateRange
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\StayDateRange
     */
    public $StayDateRange;
    /**
     * The RatePlanCandidates
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RatePlanCandidates
     */
    public $RatePlanCandidates;
    /**
     * The RoomStayCandidates
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RoomStayCandidates
     */
    public $RoomStayCandidates;
    /**
     * The HotelSearchCriteria
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\HotelSearchCriteria
     */
    public $HotelSearchCriteria;
    /**
     * The RateRange
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RateRange
     */
    public $RateRange;
    /**
     * The AvailReqType
     * @var string
     */
    public $AvailReqType;
    /**
     * The ResponseType
     * @var string
     */
    public $ResponseType;
    /**
     * Constructor method for AvailRequestSegment
     * @uses AvailRequestSegment::setStayDateRange()
     * @uses AvailRequestSegment::setRatePlanCandidates()
     * @uses AvailRequestSegment::setRoomStayCandidates()
     * @uses AvailRequestSegment::setHotelSearchCriteria()
     * @uses AvailRequestSegment::setRateRange()
     * @uses AvailRequestSegment::setAvailReqType()
     * @uses AvailRequestSegment::setResponseType()
     * @param \StructType\StayDateRange $stayDateRange
     * @param \StructType\RatePlanCandidates $ratePlanCandidates
     * @param \StructType\RoomStayCandidates $roomStayCandidates
     * @param \StructType\HotelSearchCriteria $hotelSearchCriteria
     * @param \StructType\RateRange $rateRange
     * @param string $availReqType
     * @param string $responseType
     */
    public function __construct(\StructType\StayDateRange $stayDateRange = null, \StructType\RatePlanCandidates $ratePlanCandidates = null, \StructType\RoomStayCandidates $roomStayCandidates = null, \StructType\HotelSearchCriteria $hotelSearchCriteria = null, \StructType\RateRange $rateRange = null, $availReqType = null, $responseType = null)
    {
        $this
            ->setStayDateRange($stayDateRange)
            ->setRatePlanCandidates($ratePlanCandidates)
            ->setRoomStayCandidates($roomStayCandidates)
            ->setHotelSearchCriteria($hotelSearchCriteria)
            ->setRateRange($rateRange)
            ->setAvailReqType($availReqType)
            ->setResponseType($responseType);
    }
    /**
     * Get StayDateRange value
     * @return \StructType\StayDateRange|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \StructType\StayDateRange $stayDateRange
     * @return \StructType\AvailRequestSegment
     */
    public function setStayDateRange(\StructType\StayDateRange $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get RatePlanCandidates value
     * @return \StructType\RatePlanCandidates|null
     */
    public function getRatePlanCandidates()
    {
        return $this->RatePlanCandidates;
    }
    /**
     * Set RatePlanCandidates value
     * @param \StructType\RatePlanCandidates $ratePlanCandidates
     * @return \StructType\AvailRequestSegment
     */
    public function setRatePlanCandidates(\StructType\RatePlanCandidates $ratePlanCandidates = null)
    {
        $this->RatePlanCandidates = $ratePlanCandidates;
        return $this;
    }
    /**
     * Get RoomStayCandidates value
     * @return \StructType\RoomStayCandidates|null
     */
    public function getRoomStayCandidates()
    {
        return $this->RoomStayCandidates;
    }
    /**
     * Set RoomStayCandidates value
     * @param \StructType\RoomStayCandidates $roomStayCandidates
     * @return \StructType\AvailRequestSegment
     */
    public function setRoomStayCandidates(\StructType\RoomStayCandidates $roomStayCandidates = null)
    {
        $this->RoomStayCandidates = $roomStayCandidates;
        return $this;
    }
    /**
     * Get HotelSearchCriteria value
     * @return \StructType\HotelSearchCriteria|null
     */
    public function getHotelSearchCriteria()
    {
        return $this->HotelSearchCriteria;
    }
    /**
     * Set HotelSearchCriteria value
     * @param \StructType\HotelSearchCriteria $hotelSearchCriteria
     * @return \StructType\AvailRequestSegment
     */
    public function setHotelSearchCriteria(\StructType\HotelSearchCriteria $hotelSearchCriteria = null)
    {
        $this->HotelSearchCriteria = $hotelSearchCriteria;
        return $this;
    }
    /**
     * Get RateRange value
     * @return \StructType\RateRange|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * Set RateRange value
     * @param \StructType\RateRange $rateRange
     * @return \StructType\AvailRequestSegment
     */
    public function setRateRange(\StructType\RateRange $rateRange = null)
    {
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Get AvailReqType value
     * @return string|null
     */
    public function getAvailReqType()
    {
        return $this->AvailReqType;
    }
    /**
     * Set AvailReqType value
     * @param string $availReqType
     * @return \StructType\AvailRequestSegment
     */
    public function setAvailReqType($availReqType = null)
    {
        // validation for constraint: string
        if (!is_null($availReqType) && !is_string($availReqType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availReqType, true), gettype($availReqType)), __LINE__);
        }
        $this->AvailReqType = $availReqType;
        return $this;
    }
    /**
     * Get ResponseType value
     * @return string|null
     */
    public function getResponseType()
    {
        return $this->ResponseType;
    }
    /**
     * Set ResponseType value
     * @param string $responseType
     * @return \StructType\AvailRequestSegment
     */
    public function setResponseType($responseType = null)
    {
        // validation for constraint: string
        if (!is_null($responseType) && !is_string($responseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseType, true), gettype($responseType)), __LINE__);
        }
        $this->ResponseType = $responseType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailRequestSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
