<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The AddressLine
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AddressLine;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\CountryName
     */
    public $CountryName;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The StateProv
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\StateProv
     */
    public $StateProv;
    /**
     * The FormattedInd
     * @var string
     */
    public $FormattedInd;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Address
     * @uses Address::setAddressLine()
     * @uses Address::setCityName()
     * @uses Address::setCountryName()
     * @uses Address::setPostalCode()
     * @uses Address::setStateProv()
     * @uses Address::setFormattedInd()
     * @uses Address::setType()
     * @param string[] $addressLine
     * @param string $cityName
     * @param \StructType\CountryName $countryName
     * @param string $postalCode
     * @param \StructType\StateProv $stateProv
     * @param string $formattedInd
     * @param string $type
     */
    public function __construct(array $addressLine = array(), $cityName = null, \StructType\CountryName $countryName = null, $postalCode = null, \StructType\StateProv $stateProv = null, $formattedInd = null, $type = null)
    {
        $this
            ->setAddressLine($addressLine)
            ->setCityName($cityName)
            ->setCountryName($countryName)
            ->setPostalCode($postalCode)
            ->setStateProv($stateProv)
            ->setFormattedInd($formattedInd)
            ->setType($type);
    }
    /**
     * Get AddressLine value
     * @return string[]|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressLineForArrayConstraintsFromSetAddressLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressAddressLineItem) {
            // validation for constraint: itemType
            if (!is_string($addressAddressLineItem)) {
                $invalidValues[] = is_object($addressAddressLineItem) ? get_class($addressAddressLineItem) : sprintf('%s(%s)', gettype($addressAddressLineItem), var_export($addressAddressLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressLine property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressLine value
     * @throws \InvalidArgumentException
     * @param string[] $addressLine
     * @return \StructType\Address
     */
    public function setAddressLine(array $addressLine = array())
    {
        // validation for constraint: array
        if ('' !== ($addressLineArrayErrorMessage = self::validateAddressLineForArrayConstraintsFromSetAddressLine($addressLine))) {
            throw new \InvalidArgumentException($addressLineArrayErrorMessage, __LINE__);
        }
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to AddressLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Address
     */
    public function addToAddressLine($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AddressLine property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressLine[] = $item;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\Address
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get CountryName value
     * @return \StructType\CountryName|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param \StructType\CountryName $countryName
     * @return \StructType\Address
     */
    public function setCountryName(\StructType\CountryName $countryName = null)
    {
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\Address
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get StateProv value
     * @return \StructType\StateProv|null
     */
    public function getStateProv()
    {
        return $this->StateProv;
    }
    /**
     * Set StateProv value
     * @param \StructType\StateProv $stateProv
     * @return \StructType\Address
     */
    public function setStateProv(\StructType\StateProv $stateProv = null)
    {
        $this->StateProv = $stateProv;
        return $this;
    }
    /**
     * Get FormattedInd value
     * @return string|null
     */
    public function getFormattedInd()
    {
        return $this->FormattedInd;
    }
    /**
     * Set FormattedInd value
     * @param string $formattedInd
     * @return \StructType\Address
     */
    public function setFormattedInd($formattedInd = null)
    {
        // validation for constraint: string
        if (!is_null($formattedInd) && !is_string($formattedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedInd, true), gettype($formattedInd)), __LINE__);
        }
        $this->FormattedInd = $formattedInd;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Address
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
