<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalDetail StructType
 * @subpackage Structs
 */
class AdditionalDetail extends AbstractStructBase
{
    /**
     * The DetailDescription
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\DetailDescription
     */
    public $DetailDescription;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for AdditionalDetail
     * @uses AdditionalDetail::setDetailDescription()
     * @uses AdditionalDetail::setCode()
     * @uses AdditionalDetail::setType()
     * @param \StructType\DetailDescription $detailDescription
     * @param string $code
     * @param string $type
     */
    public function __construct(\StructType\DetailDescription $detailDescription = null, $code = null, $type = null)
    {
        $this
            ->setDetailDescription($detailDescription)
            ->setCode($code)
            ->setType($type);
    }
    /**
     * Get DetailDescription value
     * @return \StructType\DetailDescription|null
     */
    public function getDetailDescription()
    {
        return $this->DetailDescription;
    }
    /**
     * Set DetailDescription value
     * @param \StructType\DetailDescription $detailDescription
     * @return \StructType\AdditionalDetail
     */
    public function setDetailDescription(\StructType\DetailDescription $detailDescription = null)
    {
        $this->DetailDescription = $detailDescription;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\AdditionalDetail
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\AdditionalDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
