<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Accommodation StructType
 * @subpackage Structs
 */
class Accommodation extends AbstractStructBase
{
    /**
     * The DateRange
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\DateRange
     */
    public $DateRange;
    /**
     * The Identity
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Identity
     */
    public $Identity;
    /**
     * The RoomProfiles
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RoomProfiles
     */
    public $RoomProfiles;
    /**
     * The SupplementCharges
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\SupplementCharges
     */
    public $SupplementCharges;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Accommodation
     * @uses Accommodation::setDateRange()
     * @uses Accommodation::setIdentity()
     * @uses Accommodation::setRoomProfiles()
     * @uses Accommodation::setSupplementCharges()
     * @uses Accommodation::setRPH()
     * @uses Accommodation::setStatus()
     * @param \StructType\DateRange $dateRange
     * @param \StructType\Identity $identity
     * @param \StructType\RoomProfiles $roomProfiles
     * @param \StructType\SupplementCharges $supplementCharges
     * @param string $rPH
     * @param string $status
     */
    public function __construct(\StructType\DateRange $dateRange = null, \StructType\Identity $identity = null, \StructType\RoomProfiles $roomProfiles = null, \StructType\SupplementCharges $supplementCharges = null, $rPH = null, $status = null)
    {
        $this
            ->setDateRange($dateRange)
            ->setIdentity($identity)
            ->setRoomProfiles($roomProfiles)
            ->setSupplementCharges($supplementCharges)
            ->setRPH($rPH)
            ->setStatus($status);
    }
    /**
     * Get DateRange value
     * @return \StructType\DateRange|null
     */
    public function getDateRange()
    {
        return $this->DateRange;
    }
    /**
     * Set DateRange value
     * @param \StructType\DateRange $dateRange
     * @return \StructType\Accommodation
     */
    public function setDateRange(\StructType\DateRange $dateRange = null)
    {
        $this->DateRange = $dateRange;
        return $this;
    }
    /**
     * Get Identity value
     * @return \StructType\Identity|null
     */
    public function getIdentity()
    {
        return $this->Identity;
    }
    /**
     * Set Identity value
     * @param \StructType\Identity $identity
     * @return \StructType\Accommodation
     */
    public function setIdentity(\StructType\Identity $identity = null)
    {
        $this->Identity = $identity;
        return $this;
    }
    /**
     * Get RoomProfiles value
     * @return \StructType\RoomProfiles|null
     */
    public function getRoomProfiles()
    {
        return $this->RoomProfiles;
    }
    /**
     * Set RoomProfiles value
     * @param \StructType\RoomProfiles $roomProfiles
     * @return \StructType\Accommodation
     */
    public function setRoomProfiles(\StructType\RoomProfiles $roomProfiles = null)
    {
        $this->RoomProfiles = $roomProfiles;
        return $this;
    }
    /**
     * Get SupplementCharges value
     * @return \StructType\SupplementCharges|null
     */
    public function getSupplementCharges()
    {
        return $this->SupplementCharges;
    }
    /**
     * Set SupplementCharges value
     * @param \StructType\SupplementCharges $supplementCharges
     * @return \StructType\Accommodation
     */
    public function setSupplementCharges(\StructType\SupplementCharges $supplementCharges = null)
    {
        $this->SupplementCharges = $supplementCharges;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\Accommodation
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\Accommodation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Accommodation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
