<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptedPayment StructType
 * Meta information extracted from the WSDL
 * - type: tns:AcceptedPayment
 * @subpackage Structs
 */
class AcceptedPayment extends AbstractStructBase
{
    /**
     * The PaymentCard
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\PaymentCard
     */
    public $PaymentCard;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for AcceptedPayment
     * @uses AcceptedPayment::setPaymentCard()
     * @uses AcceptedPayment::setRPH()
     * @param \StructType\PaymentCard $paymentCard
     * @param string $rPH
     */
    public function __construct(\StructType\PaymentCard $paymentCard = null, $rPH = null)
    {
        $this
            ->setPaymentCard($paymentCard)
            ->setRPH($rPH);
    }
    /**
     * Get PaymentCard value
     * @return \StructType\PaymentCard|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \StructType\PaymentCard $paymentCard
     * @return \StructType\AcceptedPayment
     */
    public function setPaymentCard(\StructType\PaymentCard $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AcceptedPayment
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcceptedPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
