<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ping ServiceType
 * @subpackage Services
 */
class Ping extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named pingProviders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PingRequest $oTA_PingRQ
     * @return \StructType\OTA_PingRS|bool
     */
    public function pingProviders(\StructType\PingRequest $oTA_PingRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->pingProviders($oTA_PingRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OTA_PingRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
