<?php

namespace CTT\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CTT\StructType\CreateShipment $parameters
     * @return \CTT\StructType\CreateShipmentResponse|bool
     */
    public function CreateShipment(\CTT\StructType\CreateShipment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateShipment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateShipmentWithoutPrint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CTT\StructType\CreateShipmentWithoutPrint $parameters
     * @return \CTT\StructType\CreateShipmentWithoutPrintResponse|bool
     */
    public function CreateShipmentWithoutPrint(\CTT\StructType\CreateShipmentWithoutPrint $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateShipmentWithoutPrint($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CTT\StructType\CreateShipmentResponse|\CTT\StructType\CreateShipmentWithoutPrintResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
