<?php

namespace CTT\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentCTT StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShipmentCTT
 * @subpackage Structs
 */
class ShipmentCTT extends AbstractStructBase
{
    /**
     * The DeliveryAgregation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CTT\StructType\DeliveryAggregationInf
     */
    public $DeliveryAgregation;
    /**
     * The ExtData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtData;
    /**
     * The HasSenderInformation
     * @var bool
     */
    public $HasSenderInformation;
    /**
     * The PIPAuthorization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CTT\ArrayType\ArrayOfPIPAuthorizationData
     */
    public $PIPAuthorization;
    /**
     * The ReceiverData
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CTT\StructType\AddressData
     */
    public $ReceiverData;
    /**
     * The SenderData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CTT\StructType\AddressData
     */
    public $SenderData;
    /**
     * The ShipmentData
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CTT\StructType\ShipmentData
     */
    public $ShipmentData;
    /**
     * The SpecialServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CTT\ArrayType\ArrayOfSpecialService
     */
    public $SpecialServices;
    /**
     * Constructor method for ShipmentCTT
     * @uses ShipmentCTT::setDeliveryAgregation()
     * @uses ShipmentCTT::setExtData()
     * @uses ShipmentCTT::setHasSenderInformation()
     * @uses ShipmentCTT::setPIPAuthorization()
     * @uses ShipmentCTT::setReceiverData()
     * @uses ShipmentCTT::setSenderData()
     * @uses ShipmentCTT::setShipmentData()
     * @uses ShipmentCTT::setSpecialServices()
     * @param \CTT\StructType\DeliveryAggregationInf $deliveryAgregation
     * @param string $extData
     * @param bool $hasSenderInformation
     * @param \CTT\ArrayType\ArrayOfPIPAuthorizationData $pIPAuthorization
     * @param \CTT\StructType\AddressData $receiverData
     * @param \CTT\StructType\AddressData $senderData
     * @param \CTT\StructType\ShipmentData $shipmentData
     * @param \CTT\ArrayType\ArrayOfSpecialService $specialServices
     */
    public function __construct(\CTT\StructType\DeliveryAggregationInf $deliveryAgregation = null, $extData = null, $hasSenderInformation = null, \CTT\ArrayType\ArrayOfPIPAuthorizationData $pIPAuthorization = null, \CTT\StructType\AddressData $receiverData = null, \CTT\StructType\AddressData $senderData = null, \CTT\StructType\ShipmentData $shipmentData = null, \CTT\ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        $this
            ->setDeliveryAgregation($deliveryAgregation)
            ->setExtData($extData)
            ->setHasSenderInformation($hasSenderInformation)
            ->setPIPAuthorization($pIPAuthorization)
            ->setReceiverData($receiverData)
            ->setSenderData($senderData)
            ->setShipmentData($shipmentData)
            ->setSpecialServices($specialServices);
    }
    /**
     * Get DeliveryAgregation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CTT\StructType\DeliveryAggregationInf|null
     */
    public function getDeliveryAgregation()
    {
        return isset($this->DeliveryAgregation) ? $this->DeliveryAgregation : null;
    }
    /**
     * Set DeliveryAgregation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CTT\StructType\DeliveryAggregationInf $deliveryAgregation
     * @return \CTT\StructType\ShipmentCTT
     */
    public function setDeliveryAgregation(\CTT\StructType\DeliveryAggregationInf $deliveryAgregation = null)
    {
        if (is_null($deliveryAgregation) || (is_array($deliveryAgregation) && empty($deliveryAgregation))) {
            unset($this->DeliveryAgregation);
        } else {
            $this->DeliveryAgregation = $deliveryAgregation;
        }
        return $this;
    }
    /**
     * Get ExtData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtData()
    {
        return isset($this->ExtData) ? $this->ExtData : null;
    }
    /**
     * Set ExtData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extData
     * @return \CTT\StructType\ShipmentCTT
     */
    public function setExtData($extData = null)
    {
        // validation for constraint: string
        if (!is_null($extData) && !is_string($extData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extData, true), gettype($extData)), __LINE__);
        }
        if (is_null($extData) || (is_array($extData) && empty($extData))) {
            unset($this->ExtData);
        } else {
            $this->ExtData = $extData;
        }
        return $this;
    }
    /**
     * Get HasSenderInformation value
     * @return bool|null
     */
    public function getHasSenderInformation()
    {
        return $this->HasSenderInformation;
    }
    /**
     * Set HasSenderInformation value
     * @param bool $hasSenderInformation
     * @return \CTT\StructType\ShipmentCTT
     */
    public function setHasSenderInformation($hasSenderInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasSenderInformation) && !is_bool($hasSenderInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasSenderInformation, true), gettype($hasSenderInformation)), __LINE__);
        }
        $this->HasSenderInformation = $hasSenderInformation;
        return $this;
    }
    /**
     * Get PIPAuthorization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CTT\ArrayType\ArrayOfPIPAuthorizationData|null
     */
    public function getPIPAuthorization()
    {
        return isset($this->PIPAuthorization) ? $this->PIPAuthorization : null;
    }
    /**
     * Set PIPAuthorization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CTT\ArrayType\ArrayOfPIPAuthorizationData $pIPAuthorization
     * @return \CTT\StructType\ShipmentCTT
     */
    public function setPIPAuthorization(\CTT\ArrayType\ArrayOfPIPAuthorizationData $pIPAuthorization = null)
    {
        if (is_null($pIPAuthorization) || (is_array($pIPAuthorization) && empty($pIPAuthorization))) {
            unset($this->PIPAuthorization);
        } else {
            $this->PIPAuthorization = $pIPAuthorization;
        }
        return $this;
    }
    /**
     * Get ReceiverData value
     * @return \CTT\StructType\AddressData|null
     */
    public function getReceiverData()
    {
        return $this->ReceiverData;
    }
    /**
     * Set ReceiverData value
     * @param \CTT\StructType\AddressData $receiverData
     * @return \CTT\StructType\ShipmentCTT
     */
    public function setReceiverData(\CTT\StructType\AddressData $receiverData = null)
    {
        $this->ReceiverData = $receiverData;
        return $this;
    }
    /**
     * Get SenderData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CTT\StructType\AddressData|null
     */
    public function getSenderData()
    {
        return isset($this->SenderData) ? $this->SenderData : null;
    }
    /**
     * Set SenderData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CTT\StructType\AddressData $senderData
     * @return \CTT\StructType\ShipmentCTT
     */
    public function setSenderData(\CTT\StructType\AddressData $senderData = null)
    {
        if (is_null($senderData) || (is_array($senderData) && empty($senderData))) {
            unset($this->SenderData);
        } else {
            $this->SenderData = $senderData;
        }
        return $this;
    }
    /**
     * Get ShipmentData value
     * @return \CTT\StructType\ShipmentData|null
     */
    public function getShipmentData()
    {
        return $this->ShipmentData;
    }
    /**
     * Set ShipmentData value
     * @param \CTT\StructType\ShipmentData $shipmentData
     * @return \CTT\StructType\ShipmentCTT
     */
    public function setShipmentData(\CTT\StructType\ShipmentData $shipmentData = null)
    {
        $this->ShipmentData = $shipmentData;
        return $this;
    }
    /**
     * Get SpecialServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CTT\ArrayType\ArrayOfSpecialService|null
     */
    public function getSpecialServices()
    {
        return isset($this->SpecialServices) ? $this->SpecialServices : null;
    }
    /**
     * Set SpecialServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CTT\ArrayType\ArrayOfSpecialService $specialServices
     * @return \CTT\StructType\ShipmentCTT
     */
    public function setSpecialServices(\CTT\ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        if (is_null($specialServices) || (is_array($specialServices) && empty($specialServices))) {
            unset($this->SpecialServices);
        } else {
            $this->SpecialServices = $specialServices;
        }
        return $this;
    }
}
