<?php

namespace CTT\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddressData
 * @subpackage Structs
 */
class AddressData extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactName;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The Door
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Door;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Floor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Floor;
    /**
     * The MobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NonPTZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NonPTZipCode;
    /**
     * The NonPTZipCodeLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NonPTZipCodeLocation;
    /**
     * The PTZipCode3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PTZipCode3;
    /**
     * The PTZipCode4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PTZipCode4;
    /**
     * The PTZipCodeLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PTZipCodeLocation;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for AddressData
     * @uses AddressData::setAddress()
     * @uses AddressData::setCity()
     * @uses AddressData::setContactName()
     * @uses AddressData::setCountry()
     * @uses AddressData::setDoor()
     * @uses AddressData::setEmail()
     * @uses AddressData::setFloor()
     * @uses AddressData::setMobilePhone()
     * @uses AddressData::setName()
     * @uses AddressData::setNonPTZipCode()
     * @uses AddressData::setNonPTZipCodeLocation()
     * @uses AddressData::setPTZipCode3()
     * @uses AddressData::setPTZipCode4()
     * @uses AddressData::setPTZipCodeLocation()
     * @uses AddressData::setPhone()
     * @uses AddressData::setType()
     * @param string $address
     * @param string $city
     * @param string $contactName
     * @param string $country
     * @param string $door
     * @param string $email
     * @param string $floor
     * @param string $mobilePhone
     * @param string $name
     * @param string $nonPTZipCode
     * @param string $nonPTZipCodeLocation
     * @param int $pTZipCode3
     * @param int $pTZipCode4
     * @param string $pTZipCodeLocation
     * @param string $phone
     * @param string $type
     */
    public function __construct($address = null, $city = null, $contactName = null, $country = null, $door = null, $email = null, $floor = null, $mobilePhone = null, $name = null, $nonPTZipCode = null, $nonPTZipCodeLocation = null, $pTZipCode3 = null, $pTZipCode4 = null, $pTZipCodeLocation = null, $phone = null, $type = null)
    {
        $this
            ->setAddress($address)
            ->setCity($city)
            ->setContactName($contactName)
            ->setCountry($country)
            ->setDoor($door)
            ->setEmail($email)
            ->setFloor($floor)
            ->setMobilePhone($mobilePhone)
            ->setName($name)
            ->setNonPTZipCode($nonPTZipCode)
            ->setNonPTZipCodeLocation($nonPTZipCodeLocation)
            ->setPTZipCode3($pTZipCode3)
            ->setPTZipCode4($pTZipCode4)
            ->setPTZipCodeLocation($pTZipCodeLocation)
            ->setPhone($phone)
            ->setType($type);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \CTT\StructType\AddressData
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \CTT\StructType\AddressData
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get ContactName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactName()
    {
        return isset($this->ContactName) ? $this->ContactName : null;
    }
    /**
     * Set ContactName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactName
     * @return \CTT\StructType\AddressData
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        if (is_null($contactName) || (is_array($contactName) && empty($contactName))) {
            unset($this->ContactName);
        } else {
            $this->ContactName = $contactName;
        }
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \CTT\StructType\AddressData
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Door value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoor()
    {
        return isset($this->Door) ? $this->Door : null;
    }
    /**
     * Set Door value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $door
     * @return \CTT\StructType\AddressData
     */
    public function setDoor($door = null)
    {
        // validation for constraint: string
        if (!is_null($door) && !is_string($door)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($door, true), gettype($door)), __LINE__);
        }
        if (is_null($door) || (is_array($door) && empty($door))) {
            unset($this->Door);
        } else {
            $this->Door = $door;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \CTT\StructType\AddressData
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Floor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFloor()
    {
        return isset($this->Floor) ? $this->Floor : null;
    }
    /**
     * Set Floor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $floor
     * @return \CTT\StructType\AddressData
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        if (is_null($floor) || (is_array($floor) && empty($floor))) {
            unset($this->Floor);
        } else {
            $this->Floor = $floor;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \CTT\StructType\AddressData
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \CTT\StructType\AddressData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NonPTZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNonPTZipCode()
    {
        return isset($this->NonPTZipCode) ? $this->NonPTZipCode : null;
    }
    /**
     * Set NonPTZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nonPTZipCode
     * @return \CTT\StructType\AddressData
     */
    public function setNonPTZipCode($nonPTZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($nonPTZipCode) && !is_string($nonPTZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonPTZipCode, true), gettype($nonPTZipCode)), __LINE__);
        }
        if (is_null($nonPTZipCode) || (is_array($nonPTZipCode) && empty($nonPTZipCode))) {
            unset($this->NonPTZipCode);
        } else {
            $this->NonPTZipCode = $nonPTZipCode;
        }
        return $this;
    }
    /**
     * Get NonPTZipCodeLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNonPTZipCodeLocation()
    {
        return isset($this->NonPTZipCodeLocation) ? $this->NonPTZipCodeLocation : null;
    }
    /**
     * Set NonPTZipCodeLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nonPTZipCodeLocation
     * @return \CTT\StructType\AddressData
     */
    public function setNonPTZipCodeLocation($nonPTZipCodeLocation = null)
    {
        // validation for constraint: string
        if (!is_null($nonPTZipCodeLocation) && !is_string($nonPTZipCodeLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonPTZipCodeLocation, true), gettype($nonPTZipCodeLocation)), __LINE__);
        }
        if (is_null($nonPTZipCodeLocation) || (is_array($nonPTZipCodeLocation) && empty($nonPTZipCodeLocation))) {
            unset($this->NonPTZipCodeLocation);
        } else {
            $this->NonPTZipCodeLocation = $nonPTZipCodeLocation;
        }
        return $this;
    }
    /**
     * Get PTZipCode3 value
     * @return int|null
     */
    public function getPTZipCode3()
    {
        return $this->PTZipCode3;
    }
    /**
     * Set PTZipCode3 value
     * @param int $pTZipCode3
     * @return \CTT\StructType\AddressData
     */
    public function setPTZipCode3($pTZipCode3 = null)
    {
        // validation for constraint: int
        if (!is_null($pTZipCode3) && !(is_int($pTZipCode3) || ctype_digit($pTZipCode3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pTZipCode3, true), gettype($pTZipCode3)), __LINE__);
        }
        $this->PTZipCode3 = $pTZipCode3;
        return $this;
    }
    /**
     * Get PTZipCode4 value
     * @return int|null
     */
    public function getPTZipCode4()
    {
        return $this->PTZipCode4;
    }
    /**
     * Set PTZipCode4 value
     * @param int $pTZipCode4
     * @return \CTT\StructType\AddressData
     */
    public function setPTZipCode4($pTZipCode4 = null)
    {
        // validation for constraint: int
        if (!is_null($pTZipCode4) && !(is_int($pTZipCode4) || ctype_digit($pTZipCode4))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pTZipCode4, true), gettype($pTZipCode4)), __LINE__);
        }
        $this->PTZipCode4 = $pTZipCode4;
        return $this;
    }
    /**
     * Get PTZipCodeLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPTZipCodeLocation()
    {
        return isset($this->PTZipCodeLocation) ? $this->PTZipCodeLocation : null;
    }
    /**
     * Set PTZipCodeLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pTZipCodeLocation
     * @return \CTT\StructType\AddressData
     */
    public function setPTZipCodeLocation($pTZipCodeLocation = null)
    {
        // validation for constraint: string
        if (!is_null($pTZipCodeLocation) && !is_string($pTZipCodeLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pTZipCodeLocation, true), gettype($pTZipCodeLocation)), __LINE__);
        }
        if (is_null($pTZipCodeLocation) || (is_array($pTZipCodeLocation) && empty($pTZipCodeLocation))) {
            unset($this->PTZipCodeLocation);
        } else {
            $this->PTZipCodeLocation = $pTZipCodeLocation;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \CTT\StructType\AddressData
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \CTT\EnumType\AddressTypeValues::valueIsValid()
     * @uses \CTT\EnumType\AddressTypeValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \CTT\StructType\AddressData
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\CTT\EnumType\AddressTypeValues::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CTT\EnumType\AddressTypeValues', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \CTT\EnumType\AddressTypeValues::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
