<?php

namespace CTT\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LabelData
 * @subpackage Structs
 */
class LabelData extends AbstractStructBase
{
    /**
     * The BestEncoding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BestEncoding;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * Constructor method for LabelData
     * @uses LabelData::setBestEncoding()
     * @uses LabelData::setFileName()
     * @uses LabelData::setLabel()
     * @param string $bestEncoding
     * @param string $fileName
     * @param string $label
     */
    public function __construct($bestEncoding = null, $fileName = null, $label = null)
    {
        $this
            ->setBestEncoding($bestEncoding)
            ->setFileName($fileName)
            ->setLabel($label);
    }
    /**
     * Get BestEncoding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBestEncoding()
    {
        return isset($this->BestEncoding) ? $this->BestEncoding : null;
    }
    /**
     * Set BestEncoding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bestEncoding
     * @return \CTT\StructType\LabelData
     */
    public function setBestEncoding($bestEncoding = null)
    {
        // validation for constraint: string
        if (!is_null($bestEncoding) && !is_string($bestEncoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestEncoding, true), gettype($bestEncoding)), __LINE__);
        }
        if (is_null($bestEncoding) || (is_array($bestEncoding) && empty($bestEncoding))) {
            unset($this->BestEncoding);
        } else {
            $this->BestEncoding = $bestEncoding;
        }
        return $this;
    }
    /**
     * Get FileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->FileName) ? $this->FileName : null;
    }
    /**
     * Set FileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \CTT\StructType\LabelData
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->FileName);
        } else {
            $this->FileName = $fileName;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \CTT\StructType\LabelData
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
}
