<?php

namespace CTT\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomsItemsData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomsItemsData
 * @subpackage Arrays
 */
class ArrayOfCustomsItemsData extends AbstractStructArrayBase
{
    /**
     * The CustomsItemsData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CTT\StructType\CustomsItemsData[]
     */
    public $CustomsItemsData;
    /**
     * Constructor method for ArrayOfCustomsItemsData
     * @uses ArrayOfCustomsItemsData::setCustomsItemsData()
     * @param \CTT\StructType\CustomsItemsData[] $customsItemsData
     */
    public function __construct(array $customsItemsData = array())
    {
        $this
            ->setCustomsItemsData($customsItemsData);
    }
    /**
     * Get CustomsItemsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CTT\StructType\CustomsItemsData[]|null
     */
    public function getCustomsItemsData()
    {
        return isset($this->CustomsItemsData) ? $this->CustomsItemsData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomsItemsData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomsItemsData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsItemsDataForArrayConstraintsFromSetCustomsItemsData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomsItemsDataCustomsItemsDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomsItemsDataCustomsItemsDataItem instanceof \CTT\StructType\CustomsItemsData) {
                $invalidValues[] = is_object($arrayOfCustomsItemsDataCustomsItemsDataItem) ? get_class($arrayOfCustomsItemsDataCustomsItemsDataItem) : sprintf('%s(%s)', gettype($arrayOfCustomsItemsDataCustomsItemsDataItem), var_export($arrayOfCustomsItemsDataCustomsItemsDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomsItemsData property can only contain items of type \CTT\StructType\CustomsItemsData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomsItemsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CTT\StructType\CustomsItemsData[] $customsItemsData
     * @return \CTT\ArrayType\ArrayOfCustomsItemsData
     */
    public function setCustomsItemsData(array $customsItemsData = array())
    {
        // validation for constraint: array
        if ('' !== ($customsItemsDataArrayErrorMessage = self::validateCustomsItemsDataForArrayConstraintsFromSetCustomsItemsData($customsItemsData))) {
            throw new \InvalidArgumentException($customsItemsDataArrayErrorMessage, __LINE__);
        }
        if (is_null($customsItemsData) || (is_array($customsItemsData) && empty($customsItemsData))) {
            unset($this->CustomsItemsData);
        } else {
            $this->CustomsItemsData = $customsItemsData;
        }
        return $this;
    }
    /**
     * Add item to CustomsItemsData value
     * @throws \InvalidArgumentException
     * @param \CTT\StructType\CustomsItemsData $item
     * @return \CTT\ArrayType\ArrayOfCustomsItemsData
     */
    public function addToCustomsItemsData(\CTT\StructType\CustomsItemsData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CTT\StructType\CustomsItemsData) {
            throw new \InvalidArgumentException(sprintf('The CustomsItemsData property can only contain items of type \CTT\StructType\CustomsItemsData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomsItemsData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CTT\StructType\CustomsItemsData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CTT\StructType\CustomsItemsData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CTT\StructType\CustomsItemsData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CTT\StructType\CustomsItemsData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CTT\StructType\CustomsItemsData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomsItemsData
     */
    public function getAttributeName()
    {
        return 'CustomsItemsData';
    }
}
