<?php

namespace CTT\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShipmentData
 * @subpackage Structs
 */
class ShipmentData extends AbstractStructBase
{
    /**
     * The ATCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ATCode;
    /**
     * The CargoData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CTT\StructType\CargoData
     */
    public $CargoData;
    /**
     * The ClientReference
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ClientReference;
    /**
     * The CodigoAgrupamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoAgrupamento;
    /**
     * The CustomsData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CTT\StructType\CustomsData
     */
    public $CustomsData;
    /**
     * The DeclaredValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DeclaredValue;
    /**
     * The ExportType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExportType;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Height;
    /**
     * The IsDevolution
     * @var bool
     */
    public $IsDevolution;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Length;
    /**
     * The Observations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observations;
    /**
     * The OriginalObject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalObject;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The UPUCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UPUCode;
    /**
     * The ValidationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ValidationDate;
    /**
     * The Weight
     * @var int
     */
    public $Weight;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Width;
    /**
     * Constructor method for ShipmentData
     * @uses ShipmentData::setATCode()
     * @uses ShipmentData::setCargoData()
     * @uses ShipmentData::setClientReference()
     * @uses ShipmentData::setCodigoAgrupamento()
     * @uses ShipmentData::setCustomsData()
     * @uses ShipmentData::setDeclaredValue()
     * @uses ShipmentData::setExportType()
     * @uses ShipmentData::setHeight()
     * @uses ShipmentData::setIsDevolution()
     * @uses ShipmentData::setLength()
     * @uses ShipmentData::setObservations()
     * @uses ShipmentData::setOriginalObject()
     * @uses ShipmentData::setQuantity()
     * @uses ShipmentData::setUPUCode()
     * @uses ShipmentData::setValidationDate()
     * @uses ShipmentData::setWeight()
     * @uses ShipmentData::setWidth()
     * @param string $aTCode
     * @param \CTT\StructType\CargoData $cargoData
     * @param string $clientReference
     * @param string $codigoAgrupamento
     * @param \CTT\StructType\CustomsData $customsData
     * @param float $declaredValue
     * @param string $exportType
     * @param string $height
     * @param bool $isDevolution
     * @param string $length
     * @param string $observations
     * @param string $originalObject
     * @param int $quantity
     * @param string $uPUCode
     * @param string $validationDate
     * @param int $weight
     * @param string $width
     */
    public function __construct($aTCode = null, \CTT\StructType\CargoData $cargoData = null, $clientReference = null, $codigoAgrupamento = null, \CTT\StructType\CustomsData $customsData = null, $declaredValue = null, $exportType = null, $height = null, $isDevolution = null, $length = null, $observations = null, $originalObject = null, $quantity = null, $uPUCode = null, $validationDate = null, $weight = null, $width = null)
    {
        $this
            ->setATCode($aTCode)
            ->setCargoData($cargoData)
            ->setClientReference($clientReference)
            ->setCodigoAgrupamento($codigoAgrupamento)
            ->setCustomsData($customsData)
            ->setDeclaredValue($declaredValue)
            ->setExportType($exportType)
            ->setHeight($height)
            ->setIsDevolution($isDevolution)
            ->setLength($length)
            ->setObservations($observations)
            ->setOriginalObject($originalObject)
            ->setQuantity($quantity)
            ->setUPUCode($uPUCode)
            ->setValidationDate($validationDate)
            ->setWeight($weight)
            ->setWidth($width);
    }
    /**
     * Get ATCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getATCode()
    {
        return isset($this->ATCode) ? $this->ATCode : null;
    }
    /**
     * Set ATCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aTCode
     * @return \CTT\StructType\ShipmentData
     */
    public function setATCode($aTCode = null)
    {
        // validation for constraint: string
        if (!is_null($aTCode) && !is_string($aTCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aTCode, true), gettype($aTCode)), __LINE__);
        }
        if (is_null($aTCode) || (is_array($aTCode) && empty($aTCode))) {
            unset($this->ATCode);
        } else {
            $this->ATCode = $aTCode;
        }
        return $this;
    }
    /**
     * Get CargoData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CTT\StructType\CargoData|null
     */
    public function getCargoData()
    {
        return isset($this->CargoData) ? $this->CargoData : null;
    }
    /**
     * Set CargoData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CTT\StructType\CargoData $cargoData
     * @return \CTT\StructType\ShipmentData
     */
    public function setCargoData(\CTT\StructType\CargoData $cargoData = null)
    {
        if (is_null($cargoData) || (is_array($cargoData) && empty($cargoData))) {
            unset($this->CargoData);
        } else {
            $this->CargoData = $cargoData;
        }
        return $this;
    }
    /**
     * Get ClientReference value
     * @return string|null
     */
    public function getClientReference()
    {
        return $this->ClientReference;
    }
    /**
     * Set ClientReference value
     * @param string $clientReference
     * @return \CTT\StructType\ShipmentData
     */
    public function setClientReference($clientReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientReference) && !is_string($clientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientReference, true), gettype($clientReference)), __LINE__);
        }
        $this->ClientReference = $clientReference;
        return $this;
    }
    /**
     * Get CodigoAgrupamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoAgrupamento()
    {
        return isset($this->CodigoAgrupamento) ? $this->CodigoAgrupamento : null;
    }
    /**
     * Set CodigoAgrupamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoAgrupamento
     * @return \CTT\StructType\ShipmentData
     */
    public function setCodigoAgrupamento($codigoAgrupamento = null)
    {
        // validation for constraint: string
        if (!is_null($codigoAgrupamento) && !is_string($codigoAgrupamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoAgrupamento, true), gettype($codigoAgrupamento)), __LINE__);
        }
        if (is_null($codigoAgrupamento) || (is_array($codigoAgrupamento) && empty($codigoAgrupamento))) {
            unset($this->CodigoAgrupamento);
        } else {
            $this->CodigoAgrupamento = $codigoAgrupamento;
        }
        return $this;
    }
    /**
     * Get CustomsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CTT\StructType\CustomsData|null
     */
    public function getCustomsData()
    {
        return isset($this->CustomsData) ? $this->CustomsData : null;
    }
    /**
     * Set CustomsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CTT\StructType\CustomsData $customsData
     * @return \CTT\StructType\ShipmentData
     */
    public function setCustomsData(\CTT\StructType\CustomsData $customsData = null)
    {
        if (is_null($customsData) || (is_array($customsData) && empty($customsData))) {
            unset($this->CustomsData);
        } else {
            $this->CustomsData = $customsData;
        }
        return $this;
    }
    /**
     * Get DeclaredValue value
     * @return float|null
     */
    public function getDeclaredValue()
    {
        return $this->DeclaredValue;
    }
    /**
     * Set DeclaredValue value
     * @param float $declaredValue
     * @return \CTT\StructType\ShipmentData
     */
    public function setDeclaredValue($declaredValue = null)
    {
        // validation for constraint: float
        if (!is_null($declaredValue) && !(is_float($declaredValue) || is_numeric($declaredValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($declaredValue, true), gettype($declaredValue)), __LINE__);
        }
        $this->DeclaredValue = $declaredValue;
        return $this;
    }
    /**
     * Get ExportType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExportType()
    {
        return isset($this->ExportType) ? $this->ExportType : null;
    }
    /**
     * Set ExportType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CTT\EnumType\ExportTypeValues::valueIsValid()
     * @uses \CTT\EnumType\ExportTypeValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exportType
     * @return \CTT\StructType\ShipmentData
     */
    public function setExportType($exportType = null)
    {
        // validation for constraint: enumeration
        if (!\CTT\EnumType\ExportTypeValues::valueIsValid($exportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CTT\EnumType\ExportTypeValues', is_array($exportType) ? implode(', ', $exportType) : var_export($exportType, true), implode(', ', \CTT\EnumType\ExportTypeValues::getValidValues())), __LINE__);
        }
        if (is_null($exportType) || (is_array($exportType) && empty($exportType))) {
            unset($this->ExportType);
        } else {
            $this->ExportType = $exportType;
        }
        return $this;
    }
    /**
     * Get Height value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHeight()
    {
        return isset($this->Height) ? $this->Height : null;
    }
    /**
     * Set Height value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $height
     * @return \CTT\StructType\ShipmentData
     */
    public function setHeight($height = null)
    {
        // validation for constraint: string
        if (!is_null($height) && !is_string($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        if (is_null($height) || (is_array($height) && empty($height))) {
            unset($this->Height);
        } else {
            $this->Height = $height;
        }
        return $this;
    }
    /**
     * Get IsDevolution value
     * @return bool|null
     */
    public function getIsDevolution()
    {
        return $this->IsDevolution;
    }
    /**
     * Set IsDevolution value
     * @param bool $isDevolution
     * @return \CTT\StructType\ShipmentData
     */
    public function setIsDevolution($isDevolution = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDevolution) && !is_bool($isDevolution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDevolution, true), gettype($isDevolution)), __LINE__);
        }
        $this->IsDevolution = $isDevolution;
        return $this;
    }
    /**
     * Get Length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLength()
    {
        return isset($this->Length) ? $this->Length : null;
    }
    /**
     * Set Length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $length
     * @return \CTT\StructType\ShipmentData
     */
    public function setLength($length = null)
    {
        // validation for constraint: string
        if (!is_null($length) && !is_string($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        if (is_null($length) || (is_array($length) && empty($length))) {
            unset($this->Length);
        } else {
            $this->Length = $length;
        }
        return $this;
    }
    /**
     * Get Observations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservations()
    {
        return isset($this->Observations) ? $this->Observations : null;
    }
    /**
     * Set Observations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observations
     * @return \CTT\StructType\ShipmentData
     */
    public function setObservations($observations = null)
    {
        // validation for constraint: string
        if (!is_null($observations) && !is_string($observations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observations, true), gettype($observations)), __LINE__);
        }
        if (is_null($observations) || (is_array($observations) && empty($observations))) {
            unset($this->Observations);
        } else {
            $this->Observations = $observations;
        }
        return $this;
    }
    /**
     * Get OriginalObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalObject()
    {
        return isset($this->OriginalObject) ? $this->OriginalObject : null;
    }
    /**
     * Set OriginalObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalObject
     * @return \CTT\StructType\ShipmentData
     */
    public function setOriginalObject($originalObject = null)
    {
        // validation for constraint: string
        if (!is_null($originalObject) && !is_string($originalObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalObject, true), gettype($originalObject)), __LINE__);
        }
        if (is_null($originalObject) || (is_array($originalObject) && empty($originalObject))) {
            unset($this->OriginalObject);
        } else {
            $this->OriginalObject = $originalObject;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \CTT\StructType\ShipmentData
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get UPUCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUPUCode()
    {
        return isset($this->UPUCode) ? $this->UPUCode : null;
    }
    /**
     * Set UPUCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CTT\EnumType\UPUCodeValues::valueIsValid()
     * @uses \CTT\EnumType\UPUCodeValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $uPUCode
     * @return \CTT\StructType\ShipmentData
     */
    public function setUPUCode($uPUCode = null)
    {
        // validation for constraint: enumeration
        if (!\CTT\EnumType\UPUCodeValues::valueIsValid($uPUCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CTT\EnumType\UPUCodeValues', is_array($uPUCode) ? implode(', ', $uPUCode) : var_export($uPUCode, true), implode(', ', \CTT\EnumType\UPUCodeValues::getValidValues())), __LINE__);
        }
        if (is_null($uPUCode) || (is_array($uPUCode) && empty($uPUCode))) {
            unset($this->UPUCode);
        } else {
            $this->UPUCode = $uPUCode;
        }
        return $this;
    }
    /**
     * Get ValidationDate value
     * @return string|null
     */
    public function getValidationDate()
    {
        return $this->ValidationDate;
    }
    /**
     * Set ValidationDate value
     * @param string $validationDate
     * @return \CTT\StructType\ShipmentData
     */
    public function setValidationDate($validationDate = null)
    {
        // validation for constraint: string
        if (!is_null($validationDate) && !is_string($validationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationDate, true), gettype($validationDate)), __LINE__);
        }
        $this->ValidationDate = $validationDate;
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \CTT\StructType\ShipmentData
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !(is_int($weight) || ctype_digit($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Width value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWidth()
    {
        return isset($this->Width) ? $this->Width : null;
    }
    /**
     * Set Width value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $width
     * @return \CTT\StructType\ShipmentData
     */
    public function setWidth($width = null)
    {
        // validation for constraint: string
        if (!is_null($width) && !is_string($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        if (is_null($width) || (is_array($width) && empty($width))) {
            unset($this->Width);
        } else {
            $this->Width = $width;
        }
        return $this;
    }
}
