<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://cttexpressows.qa.ctt.pt/CTTEWSPool/CTTShipmentProviderWS.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://cttexpressows.qa.ctt.pt/CTTEWSPool/CTTShipmentProviderWS.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \CTT\ClassMap::get(),
);
/**
 * Samples for Complete ServiceType
 */
$complete = new \CTT\ServiceType\Complete($options);
/**
 * Sample call for CompleteShipment operation/method
 */
if ($complete->CompleteShipment(new \CTT\StructType\CompleteShipment()) !== false) {
    print_r($complete->getResult());
} else {
    print_r($complete->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \CTT\ServiceType\Create($options);
/**
 * Sample call for CreateShipment operation/method
 */
if ($create->CreateShipment(new \CTT\StructType\CreateShipment()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateShipmentWithoutPrint operation/method
 */
if ($create->CreateShipmentWithoutPrint(new \CTT\StructType\CreateShipmentWithoutPrint()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Close ServiceType
 */
$close = new \CTT\ServiceType\Close($options);
/**
 * Sample call for CloseShipment operation/method
 */
if ($close->CloseShipment(new \CTT\StructType\CloseShipment()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
