<?php

namespace CTT\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PIPAuthorizationData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PIPAuthorizationData
 * @subpackage Structs
 */
class PIPAuthorizationData extends AbstractStructBase
{
    /**
     * The PIPType
     * @var string
     */
    public $PIPType;
    /**
     * Constructor method for PIPAuthorizationData
     * @uses PIPAuthorizationData::setPIPType()
     * @param string $pIPType
     */
    public function __construct($pIPType = null)
    {
        $this
            ->setPIPType($pIPType);
    }
    /**
     * Get PIPType value
     * @return string|null
     */
    public function getPIPType()
    {
        return $this->PIPType;
    }
    /**
     * Set PIPType value
     * @uses \CTT\EnumType\PIPTypeValues::valueIsValid()
     * @uses \CTT\EnumType\PIPTypeValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pIPType
     * @return \CTT\StructType\PIPAuthorizationData
     */
    public function setPIPType($pIPType = null)
    {
        // validation for constraint: enumeration
        if (!\CTT\EnumType\PIPTypeValues::valueIsValid($pIPType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CTT\EnumType\PIPTypeValues', is_array($pIPType) ? implode(', ', $pIPType) : var_export($pIPType, true), implode(', ', \CTT\EnumType\PIPTypeValues::getValidValues())), __LINE__);
        }
        $this->PIPType = $pIPType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CTT\StructType\PIPAuthorizationData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
