<?php

namespace CTT\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryAggregationInf StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryAggregationInf
 * @subpackage Structs
 */
class DeliveryAggregationInf extends AbstractStructBase
{
    /**
     * The DeliveryAggregationNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryAggregationNum;
    /**
     * The IsLastShippment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsLastShippment;
    /**
     * The IsPartialDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPartialDelivery;
    /**
     * The IsSingleCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSingleCharge;
    /**
     * The RefDeliveryAggregation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefDeliveryAggregation;
    /**
     * Constructor method for DeliveryAggregationInf
     * @uses DeliveryAggregationInf::setDeliveryAggregationNum()
     * @uses DeliveryAggregationInf::setIsLastShippment()
     * @uses DeliveryAggregationInf::setIsPartialDelivery()
     * @uses DeliveryAggregationInf::setIsSingleCharge()
     * @uses DeliveryAggregationInf::setRefDeliveryAggregation()
     * @param string $deliveryAggregationNum
     * @param bool $isLastShippment
     * @param bool $isPartialDelivery
     * @param bool $isSingleCharge
     * @param string $refDeliveryAggregation
     */
    public function __construct($deliveryAggregationNum = null, $isLastShippment = null, $isPartialDelivery = null, $isSingleCharge = null, $refDeliveryAggregation = null)
    {
        $this
            ->setDeliveryAggregationNum($deliveryAggregationNum)
            ->setIsLastShippment($isLastShippment)
            ->setIsPartialDelivery($isPartialDelivery)
            ->setIsSingleCharge($isSingleCharge)
            ->setRefDeliveryAggregation($refDeliveryAggregation);
    }
    /**
     * Get DeliveryAggregationNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryAggregationNum()
    {
        return isset($this->DeliveryAggregationNum) ? $this->DeliveryAggregationNum : null;
    }
    /**
     * Set DeliveryAggregationNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryAggregationNum
     * @return \CTT\StructType\DeliveryAggregationInf
     */
    public function setDeliveryAggregationNum($deliveryAggregationNum = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAggregationNum) && !is_string($deliveryAggregationNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAggregationNum, true), gettype($deliveryAggregationNum)), __LINE__);
        }
        if (is_null($deliveryAggregationNum) || (is_array($deliveryAggregationNum) && empty($deliveryAggregationNum))) {
            unset($this->DeliveryAggregationNum);
        } else {
            $this->DeliveryAggregationNum = $deliveryAggregationNum;
        }
        return $this;
    }
    /**
     * Get IsLastShippment value
     * @return bool|null
     */
    public function getIsLastShippment()
    {
        return $this->IsLastShippment;
    }
    /**
     * Set IsLastShippment value
     * @param bool $isLastShippment
     * @return \CTT\StructType\DeliveryAggregationInf
     */
    public function setIsLastShippment($isLastShippment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLastShippment) && !is_bool($isLastShippment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLastShippment, true), gettype($isLastShippment)), __LINE__);
        }
        $this->IsLastShippment = $isLastShippment;
        return $this;
    }
    /**
     * Get IsPartialDelivery value
     * @return bool|null
     */
    public function getIsPartialDelivery()
    {
        return $this->IsPartialDelivery;
    }
    /**
     * Set IsPartialDelivery value
     * @param bool $isPartialDelivery
     * @return \CTT\StructType\DeliveryAggregationInf
     */
    public function setIsPartialDelivery($isPartialDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartialDelivery) && !is_bool($isPartialDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartialDelivery, true), gettype($isPartialDelivery)), __LINE__);
        }
        $this->IsPartialDelivery = $isPartialDelivery;
        return $this;
    }
    /**
     * Get IsSingleCharge value
     * @return bool|null
     */
    public function getIsSingleCharge()
    {
        return $this->IsSingleCharge;
    }
    /**
     * Set IsSingleCharge value
     * @param bool $isSingleCharge
     * @return \CTT\StructType\DeliveryAggregationInf
     */
    public function setIsSingleCharge($isSingleCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSingleCharge) && !is_bool($isSingleCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSingleCharge, true), gettype($isSingleCharge)), __LINE__);
        }
        $this->IsSingleCharge = $isSingleCharge;
        return $this;
    }
    /**
     * Get RefDeliveryAggregation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefDeliveryAggregation()
    {
        return isset($this->RefDeliveryAggregation) ? $this->RefDeliveryAggregation : null;
    }
    /**
     * Set RefDeliveryAggregation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refDeliveryAggregation
     * @return \CTT\StructType\DeliveryAggregationInf
     */
    public function setRefDeliveryAggregation($refDeliveryAggregation = null)
    {
        // validation for constraint: string
        if (!is_null($refDeliveryAggregation) && !is_string($refDeliveryAggregation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refDeliveryAggregation, true), gettype($refDeliveryAggregation)), __LINE__);
        }
        if (is_null($refDeliveryAggregation) || (is_array($refDeliveryAggregation) && empty($refDeliveryAggregation))) {
            unset($this->RefDeliveryAggregation);
        } else {
            $this->RefDeliveryAggregation = $refDeliveryAggregation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CTT\StructType\DeliveryAggregationInf
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
