<?php

namespace CTT\EnumType;

/**
 * This class stands for PIPTypeValues EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PIPTypeValues
 * @subpackage Enumerations
 */
class PIPTypeValues
{
    /**
     * Constant for value 'AddressChange'
     * @return string 'AddressChange'
     */
    const VALUE_ADDRESS_CHANGE = 'AddressChange';
    /**
     * Constant for value 'DeliveryDateChange'
     * @return string 'DeliveryDateChange'
     */
    const VALUE_DELIVERY_DATE_CHANGE = 'DeliveryDateChange';
    /**
     * Constant for value 'DeliveryWindowChange'
     * @return string 'DeliveryWindowChange'
     */
    const VALUE_DELIVERY_WINDOW_CHANGE = 'DeliveryWindowChange';
    /**
     * Constant for value 'PickUpPeriodChange'
     * @return string 'PickUpPeriodChange'
     */
    const VALUE_PICK_UP_PERIOD_CHANGE = 'PickUpPeriodChange';
    /**
     * Constant for value 'AnotherDeliveryTry'
     * @return string 'AnotherDeliveryTry'
     */
    const VALUE_ANOTHER_DELIVERY_TRY = 'AnotherDeliveryTry';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADDRESS_CHANGE
     * @uses self::VALUE_DELIVERY_DATE_CHANGE
     * @uses self::VALUE_DELIVERY_WINDOW_CHANGE
     * @uses self::VALUE_PICK_UP_PERIOD_CHANGE
     * @uses self::VALUE_ANOTHER_DELIVERY_TRY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADDRESS_CHANGE,
            self::VALUE_DELIVERY_DATE_CHANGE,
            self::VALUE_DELIVERY_WINDOW_CHANGE,
            self::VALUE_PICK_UP_PERIOD_CHANGE,
            self::VALUE_ANOTHER_DELIVERY_TRY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
