<?php

namespace CTT\EnumType;

/**
 * This class stands for InNonDeliveryCaseTypeValues EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InNonDeliveryCaseTypeValues
 * @subpackage Enumerations
 */
class InNonDeliveryCaseTypeValues
{
    /**
     * Constant for value 'SendToSender'
     * @return string 'SendToSender'
     */
    const VALUE_SEND_TO_SENDER = 'SendToSender';
    /**
     * Constant for value 'SendToAddress'
     * @return string 'SendToAddress'
     */
    const VALUE_SEND_TO_ADDRESS = 'SendToAddress';
    /**
     * Constant for value 'SendToDeliveryPoint'
     * @return string 'SendToDeliveryPoint'
     */
    const VALUE_SEND_TO_DELIVERY_POINT = 'SendToDeliveryPoint';
    /**
     * Constant for value 'PostOfficeNotiffied'
     * @return string 'PostOfficeNotiffied'
     */
    const VALUE_POST_OFFICE_NOTIFFIED = 'PostOfficeNotiffied';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SEND_TO_SENDER
     * @uses self::VALUE_SEND_TO_ADDRESS
     * @uses self::VALUE_SEND_TO_DELIVERY_POINT
     * @uses self::VALUE_POST_OFFICE_NOTIFFIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SEND_TO_SENDER,
            self::VALUE_SEND_TO_ADDRESS,
            self::VALUE_SEND_TO_DELIVERY_POINT,
            self::VALUE_POST_OFFICE_NOTIFFIED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
