<?php

namespace CTT\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDocumentData
 * @subpackage Arrays
 */
class ArrayOfDocumentData extends AbstractStructArrayBase
{
    /**
     * The DocumentData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CTT\StructType\DocumentData[]
     */
    public $DocumentData;
    /**
     * Constructor method for ArrayOfDocumentData
     * @uses ArrayOfDocumentData::setDocumentData()
     * @param \CTT\StructType\DocumentData[] $documentData
     */
    public function __construct(array $documentData = array())
    {
        $this
            ->setDocumentData($documentData);
    }
    /**
     * Get DocumentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CTT\StructType\DocumentData[]|null
     */
    public function getDocumentData()
    {
        return isset($this->DocumentData) ? $this->DocumentData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentDataForArrayConstraintsFromSetDocumentData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDocumentDataDocumentDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentDataDocumentDataItem instanceof \CTT\StructType\DocumentData) {
                $invalidValues[] = is_object($arrayOfDocumentDataDocumentDataItem) ? get_class($arrayOfDocumentDataDocumentDataItem) : sprintf('%s(%s)', gettype($arrayOfDocumentDataDocumentDataItem), var_export($arrayOfDocumentDataDocumentDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentData property can only contain items of type \CTT\StructType\DocumentData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CTT\StructType\DocumentData[] $documentData
     * @return \CTT\ArrayType\ArrayOfDocumentData
     */
    public function setDocumentData(array $documentData = array())
    {
        // validation for constraint: array
        if ('' !== ($documentDataArrayErrorMessage = self::validateDocumentDataForArrayConstraintsFromSetDocumentData($documentData))) {
            throw new \InvalidArgumentException($documentDataArrayErrorMessage, __LINE__);
        }
        if (is_null($documentData) || (is_array($documentData) && empty($documentData))) {
            unset($this->DocumentData);
        } else {
            $this->DocumentData = $documentData;
        }
        return $this;
    }
    /**
     * Add item to DocumentData value
     * @throws \InvalidArgumentException
     * @param \CTT\StructType\DocumentData $item
     * @return \CTT\ArrayType\ArrayOfDocumentData
     */
    public function addToDocumentData(\CTT\StructType\DocumentData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CTT\StructType\DocumentData) {
            throw new \InvalidArgumentException(sprintf('The DocumentData property can only contain items of type \CTT\StructType\DocumentData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CTT\StructType\DocumentData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CTT\StructType\DocumentData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CTT\StructType\DocumentData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CTT\StructType\DocumentData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CTT\StructType\DocumentData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentData
     */
    public function getAttributeName()
    {
        return 'DocumentData';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CTT\ArrayType\ArrayOfDocumentData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
