<?php

namespace CTT\EnumType;

/**
 * This class stands for NonDeliveryCaseValues EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NonDeliveryCaseValues
 * @subpackage Enumerations
 */
class NonDeliveryCaseValues
{
    /**
     * Constant for value 'GiveBack'
     * @return string 'GiveBack'
     */
    const VALUE_GIVE_BACK = 'GiveBack';
    /**
     * Constant for value 'ToAbandon'
     * @return string 'ToAbandon'
     */
    const VALUE_TO_ABANDON = 'ToAbandon';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GIVE_BACK
     * @uses self::VALUE_TO_ABANDON
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GIVE_BACK,
            self::VALUE_TO_ABANDON,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
