<?php

namespace CTT\EnumType;

/**
 * This class stands for DeliveryPointTypeValues EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryPointTypeValues
 * @subpackage Enumerations
 */
class DeliveryPointTypeValues
{
    /**
     * Constant for value 'PostOffice'
     * @return string 'PostOffice'
     */
    const VALUE_POST_OFFICE = 'PostOffice';
    /**
     * Constant for value 'Shop'
     * @return string 'Shop'
     */
    const VALUE_SHOP = 'Shop';
    /**
     * Constant for value 'ParcelLocker'
     * @return string 'ParcelLocker'
     */
    const VALUE_PARCEL_LOCKER = 'ParcelLocker';
    /**
     * Constant for value 'PostalCollectionFacility'
     * @return string 'PostalCollectionFacility'
     */
    const VALUE_POSTAL_COLLECTION_FACILITY = 'PostalCollectionFacility';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_POST_OFFICE
     * @uses self::VALUE_SHOP
     * @uses self::VALUE_PARCEL_LOCKER
     * @uses self::VALUE_POSTAL_COLLECTION_FACILITY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_POST_OFFICE,
            self::VALUE_SHOP,
            self::VALUE_PARCEL_LOCKER,
            self::VALUE_POSTAL_COLLECTION_FACILITY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
