<?php

namespace CTT\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeWindowData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TimeWindowData
 * @subpackage Structs
 */
class TimeWindowData extends AbstractStructBase
{
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The TimeWindow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TimeWindow;
    /**
     * Constructor method for TimeWindowData
     * @uses TimeWindowData::setDeliveryDate()
     * @uses TimeWindowData::setTimeWindow()
     * @param string $deliveryDate
     * @param string $timeWindow
     */
    public function __construct($deliveryDate = null, $timeWindow = null)
    {
        $this
            ->setDeliveryDate($deliveryDate)
            ->setTimeWindow($timeWindow);
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \CTT\StructType\TimeWindowData
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get TimeWindow value
     * @return string|null
     */
    public function getTimeWindow()
    {
        return $this->TimeWindow;
    }
    /**
     * Set TimeWindow value
     * @uses \CTT\EnumType\TimeWindowValues::valueIsValid()
     * @uses \CTT\EnumType\TimeWindowValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeWindow
     * @return \CTT\StructType\TimeWindowData
     */
    public function setTimeWindow($timeWindow = null)
    {
        // validation for constraint: enumeration
        if (!\CTT\EnumType\TimeWindowValues::valueIsValid($timeWindow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CTT\EnumType\TimeWindowValues', is_array($timeWindow) ? implode(', ', $timeWindow) : var_export($timeWindow, true), implode(', ', \CTT\EnumType\TimeWindowValues::getValidValues())), __LINE__);
        }
        $this->TimeWindow = $timeWindow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CTT\StructType\TimeWindowData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
