<?php

namespace CTT\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CargoData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CargoData
 * @subpackage Structs
 */
class CargoData extends AbstractStructBase
{
    /**
     * The PartialDelivery
     * @var bool
     */
    public $PartialDelivery;
    /**
     * The SchedulingData
     * @var string
     */
    public $SchedulingData;
    /**
     * The SchedulingHour
     * @var string
     */
    public $SchedulingHour;
    /**
     * Constructor method for CargoData
     * @uses CargoData::setPartialDelivery()
     * @uses CargoData::setSchedulingData()
     * @uses CargoData::setSchedulingHour()
     * @param bool $partialDelivery
     * @param string $schedulingData
     * @param string $schedulingHour
     */
    public function __construct($partialDelivery = null, $schedulingData = null, $schedulingHour = null)
    {
        $this
            ->setPartialDelivery($partialDelivery)
            ->setSchedulingData($schedulingData)
            ->setSchedulingHour($schedulingHour);
    }
    /**
     * Get PartialDelivery value
     * @return bool|null
     */
    public function getPartialDelivery()
    {
        return $this->PartialDelivery;
    }
    /**
     * Set PartialDelivery value
     * @param bool $partialDelivery
     * @return \CTT\StructType\CargoData
     */
    public function setPartialDelivery($partialDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($partialDelivery) && !is_bool($partialDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($partialDelivery, true), gettype($partialDelivery)), __LINE__);
        }
        $this->PartialDelivery = $partialDelivery;
        return $this;
    }
    /**
     * Get SchedulingData value
     * @return string|null
     */
    public function getSchedulingData()
    {
        return $this->SchedulingData;
    }
    /**
     * Set SchedulingData value
     * @param string $schedulingData
     * @return \CTT\StructType\CargoData
     */
    public function setSchedulingData($schedulingData = null)
    {
        // validation for constraint: string
        if (!is_null($schedulingData) && !is_string($schedulingData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedulingData, true), gettype($schedulingData)), __LINE__);
        }
        $this->SchedulingData = $schedulingData;
        return $this;
    }
    /**
     * Get SchedulingHour value
     * @return string|null
     */
    public function getSchedulingHour()
    {
        return $this->SchedulingHour;
    }
    /**
     * Set SchedulingHour value
     * @param string $schedulingHour
     * @return \CTT\StructType\CargoData
     */
    public function setSchedulingHour($schedulingHour = null)
    {
        // validation for constraint: string
        if (!is_null($schedulingHour) && !is_string($schedulingHour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedulingHour, true), gettype($schedulingHour)), __LINE__);
        }
        $this->SchedulingHour = $schedulingHour;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CTT\StructType\CargoData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
