<?php

namespace CTT\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Complete ServiceType
 * @subpackage Services
 */
class Complete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CompleteShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CTT\StructType\CompleteShipment $parameters
     * @return \CTT\StructType\CompleteShipmentResponse|bool
     */
    public function CompleteShipment(\CTT\StructType\CompleteShipment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CompleteShipment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CTT\StructType\CompleteShipmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
