<?php

namespace CTT\EnumType;

/**
 * This class stands for UPUCodeValues EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UPUCodeValues
 * @subpackage Enumerations
 */
class UPUCodeValues
{
    /**
     * Constant for value 'Samples'
     * @return string 'Samples'
     */
    const VALUE_SAMPLES = 'Samples';
    /**
     * Constant for value 'Documents'
     * @return string 'Documents'
     */
    const VALUE_DOCUMENTS = 'Documents';
    /**
     * Constant for value 'Goods'
     * @return string 'Goods'
     */
    const VALUE_GOODS = 'Goods';
    /**
     * Constant for value 'Others'
     * @return string 'Others'
     */
    const VALUE_OTHERS = 'Others';
    /**
     * Constant for value 'Gift'
     * @return string 'Gift'
     */
    const VALUE_GIFT = 'Gift';
    /**
     * Constant for value 'Devolution'
     * @return string 'Devolution'
     */
    const VALUE_DEVOLUTION = 'Devolution';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SAMPLES
     * @uses self::VALUE_DOCUMENTS
     * @uses self::VALUE_GOODS
     * @uses self::VALUE_OTHERS
     * @uses self::VALUE_GIFT
     * @uses self::VALUE_DEVOLUTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SAMPLES,
            self::VALUE_DOCUMENTS,
            self::VALUE_GOODS,
            self::VALUE_OTHERS,
            self::VALUE_GIFT,
            self::VALUE_DEVOLUTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
