<?php

namespace CTT\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CloseShipmentInput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CloseShipmentInput
 * @subpackage Structs
 */
class CloseShipmentInput extends AbstractStructBase
{
    /**
     * The AuthenticationID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AuthenticationID;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ClientId;
    /**
     * The ContractId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ContractId;
    /**
     * The DistributionChannel
     * @var int
     */
    public $DistributionChannel;
    /**
     * The ListOfShipmentToClose
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CTT\ArrayType\ArrayOfShipment2Close
     */
    public $ListOfShipmentToClose;
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestID;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserID;
    /**
     * Constructor method for CloseShipmentInput
     * @uses CloseShipmentInput::setAuthenticationID()
     * @uses CloseShipmentInput::setClientId()
     * @uses CloseShipmentInput::setContractId()
     * @uses CloseShipmentInput::setDistributionChannel()
     * @uses CloseShipmentInput::setListOfShipmentToClose()
     * @uses CloseShipmentInput::setRequestID()
     * @uses CloseShipmentInput::setUserID()
     * @param string $authenticationID
     * @param string $clientId
     * @param string $contractId
     * @param int $distributionChannel
     * @param \CTT\ArrayType\ArrayOfShipment2Close $listOfShipmentToClose
     * @param string $requestID
     * @param string $userID
     */
    public function __construct($authenticationID = null, $clientId = null, $contractId = null, $distributionChannel = null, \CTT\ArrayType\ArrayOfShipment2Close $listOfShipmentToClose = null, $requestID = null, $userID = null)
    {
        $this
            ->setAuthenticationID($authenticationID)
            ->setClientId($clientId)
            ->setContractId($contractId)
            ->setDistributionChannel($distributionChannel)
            ->setListOfShipmentToClose($listOfShipmentToClose)
            ->setRequestID($requestID)
            ->setUserID($userID);
    }
    /**
     * Get AuthenticationID value
     * @return string|null
     */
    public function getAuthenticationID()
    {
        return $this->AuthenticationID;
    }
    /**
     * Set AuthenticationID value
     * @param string $authenticationID
     * @return \CTT\StructType\CloseShipmentInput
     */
    public function setAuthenticationID($authenticationID = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationID) && !is_string($authenticationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationID, true), gettype($authenticationID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($authenticationID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $authenticationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($authenticationID, true)), __LINE__);
        }
        $this->AuthenticationID = $authenticationID;
        return $this;
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \CTT\StructType\CloseShipmentInput
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get ContractId value
     * @return string|null
     */
    public function getContractId()
    {
        return $this->ContractId;
    }
    /**
     * Set ContractId value
     * @param string $contractId
     * @return \CTT\StructType\CloseShipmentInput
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: string
        if (!is_null($contractId) && !is_string($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractId, true), gettype($contractId)), __LINE__);
        }
        $this->ContractId = $contractId;
        return $this;
    }
    /**
     * Get DistributionChannel value
     * @return int|null
     */
    public function getDistributionChannel()
    {
        return $this->DistributionChannel;
    }
    /**
     * Set DistributionChannel value
     * @param int $distributionChannel
     * @return \CTT\StructType\CloseShipmentInput
     */
    public function setDistributionChannel($distributionChannel = null)
    {
        // validation for constraint: int
        if (!is_null($distributionChannel) && !(is_int($distributionChannel) || ctype_digit($distributionChannel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distributionChannel, true), gettype($distributionChannel)), __LINE__);
        }
        $this->DistributionChannel = $distributionChannel;
        return $this;
    }
    /**
     * Get ListOfShipmentToClose value
     * @return \CTT\ArrayType\ArrayOfShipment2Close|null
     */
    public function getListOfShipmentToClose()
    {
        return $this->ListOfShipmentToClose;
    }
    /**
     * Set ListOfShipmentToClose value
     * @param \CTT\ArrayType\ArrayOfShipment2Close $listOfShipmentToClose
     * @return \CTT\StructType\CloseShipmentInput
     */
    public function setListOfShipmentToClose(\CTT\ArrayType\ArrayOfShipment2Close $listOfShipmentToClose = null)
    {
        $this->ListOfShipmentToClose = $listOfShipmentToClose;
        return $this;
    }
    /**
     * Get RequestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param string $requestID
     * @return \CTT\StructType\CloseShipmentInput
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestID, true)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get UserID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserID()
    {
        return isset($this->UserID) ? $this->UserID : null;
    }
    /**
     * Set UserID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userID
     * @return \CTT\StructType\CloseShipmentInput
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userID, true)), __LINE__);
        }
        if (is_null($userID) || (is_array($userID) && empty($userID))) {
            unset($this->UserID);
        } else {
            $this->UserID = $userID;
        }
        return $this;
    }
}
