<?php

namespace CTT\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnAuthorizationData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReturnAuthorizationData
 * @subpackage Structs
 */
class ReturnAuthorizationData extends AbstractStructBase
{
    /**
     * The AddressData
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CTT\StructType\AddressData
     */
    public $AddressData;
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProductCode;
    /**
     * The ValidationDate
     * @var string
     */
    public $ValidationDate;
    /**
     * Constructor method for ReturnAuthorizationData
     * @uses ReturnAuthorizationData::setAddressData()
     * @uses ReturnAuthorizationData::setProductCode()
     * @uses ReturnAuthorizationData::setValidationDate()
     * @param \CTT\StructType\AddressData $addressData
     * @param string $productCode
     * @param string $validationDate
     */
    public function __construct(\CTT\StructType\AddressData $addressData = null, $productCode = null, $validationDate = null)
    {
        $this
            ->setAddressData($addressData)
            ->setProductCode($productCode)
            ->setValidationDate($validationDate);
    }
    /**
     * Get AddressData value
     * @return \CTT\StructType\AddressData|null
     */
    public function getAddressData()
    {
        return $this->AddressData;
    }
    /**
     * Set AddressData value
     * @param \CTT\StructType\AddressData $addressData
     * @return \CTT\StructType\ReturnAuthorizationData
     */
    public function setAddressData(\CTT\StructType\AddressData $addressData = null)
    {
        $this->AddressData = $addressData;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \CTT\StructType\ReturnAuthorizationData
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get ValidationDate value
     * @return string|null
     */
    public function getValidationDate()
    {
        return $this->ValidationDate;
    }
    /**
     * Set ValidationDate value
     * @param string $validationDate
     * @return \CTT\StructType\ReturnAuthorizationData
     */
    public function setValidationDate($validationDate = null)
    {
        // validation for constraint: string
        if (!is_null($validationDate) && !is_string($validationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationDate, true), gettype($validationDate)), __LINE__);
        }
        $this->ValidationDate = $validationDate;
        return $this;
    }
}
