<?php

namespace CTT\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryPointData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryPointData
 * @subpackage Structs
 */
class DeliveryPointData extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for DeliveryPointData
     * @uses DeliveryPointData::setCode()
     * @uses DeliveryPointData::setName()
     * @uses DeliveryPointData::setType()
     * @param string $code
     * @param string $name
     * @param string $type
     */
    public function __construct($code = null, $name = null, $type = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setType($type);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \CTT\StructType\DeliveryPointData
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \CTT\StructType\DeliveryPointData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \CTT\EnumType\DeliveryPointTypeValues::valueIsValid()
     * @uses \CTT\EnumType\DeliveryPointTypeValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \CTT\StructType\DeliveryPointData
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\CTT\EnumType\DeliveryPointTypeValues::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CTT\EnumType\DeliveryPointTypeValues', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \CTT\EnumType\DeliveryPointTypeValues::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
