<?php

namespace CTT\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfErrorData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfErrorData
 * @subpackage Arrays
 */
class ArrayOfErrorData extends AbstractStructArrayBase
{
    /**
     * The ErrorData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CTT\StructType\ErrorData[]
     */
    public $ErrorData;
    /**
     * Constructor method for ArrayOfErrorData
     * @uses ArrayOfErrorData::setErrorData()
     * @param \CTT\StructType\ErrorData[] $errorData
     */
    public function __construct(array $errorData = array())
    {
        $this
            ->setErrorData($errorData);
    }
    /**
     * Get ErrorData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CTT\StructType\ErrorData[]|null
     */
    public function getErrorData()
    {
        return isset($this->ErrorData) ? $this->ErrorData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setErrorData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrorData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorDataForArrayConstraintsFromSetErrorData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfErrorDataErrorDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfErrorDataErrorDataItem instanceof \CTT\StructType\ErrorData) {
                $invalidValues[] = is_object($arrayOfErrorDataErrorDataItem) ? get_class($arrayOfErrorDataErrorDataItem) : sprintf('%s(%s)', gettype($arrayOfErrorDataErrorDataItem), var_export($arrayOfErrorDataErrorDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ErrorData property can only contain items of type \CTT\StructType\ErrorData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ErrorData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CTT\StructType\ErrorData[] $errorData
     * @return \CTT\ArrayType\ArrayOfErrorData
     */
    public function setErrorData(array $errorData = array())
    {
        // validation for constraint: array
        if ('' !== ($errorDataArrayErrorMessage = self::validateErrorDataForArrayConstraintsFromSetErrorData($errorData))) {
            throw new \InvalidArgumentException($errorDataArrayErrorMessage, __LINE__);
        }
        if (is_null($errorData) || (is_array($errorData) && empty($errorData))) {
            unset($this->ErrorData);
        } else {
            $this->ErrorData = $errorData;
        }
        return $this;
    }
    /**
     * Add item to ErrorData value
     * @throws \InvalidArgumentException
     * @param \CTT\StructType\ErrorData $item
     * @return \CTT\ArrayType\ArrayOfErrorData
     */
    public function addToErrorData(\CTT\StructType\ErrorData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CTT\StructType\ErrorData) {
            throw new \InvalidArgumentException(sprintf('The ErrorData property can only contain items of type \CTT\StructType\ErrorData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ErrorData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CTT\StructType\ErrorData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CTT\StructType\ErrorData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CTT\StructType\ErrorData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CTT\StructType\ErrorData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CTT\StructType\ErrorData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ErrorData
     */
    public function getAttributeName()
    {
        return 'ErrorData';
    }
}
