<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://t-t.sps-sro.sk/service_soap.php?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://t-t.sps-sro.sk/service_soap.php?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \ups_sk\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ups_sk\ServiceType\Get($options);
/**
 * Sample call for getTest operation/method
 */
if ($get->getTest() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getListOfShipments operation/method
 */
if ($get->getListOfShipments($kundenr, $verknr, $km_mandr, $versdat, $langi) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipment operation/method
 */
if ($get->getShipment($landnr, $mandnr, $lfdnr, $langi) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getListOfParcels operation/method
 */
if ($get->getListOfParcels($landnr, $mandnr, $lfdnr, $langi) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getParcelStatus operation/method
 */
if ($get->getParcelStatus($landnr, $mandnr, $lfdnr, $langi) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
