<?php

namespace ups_sk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParcelStatus StructType
 * @subpackage Structs
 */
class ParcelStatus extends AbstractStructBase
{
    /**
     * The ParcelNumber
     * @var string
     */
    public $ParcelNumber;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The Time
     * @var string
     */
    public $Time;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The StatusCodeX
     * @var int
     */
    public $StatusCodeX;
    /**
     * The Center
     * @var string
     */
    public $Center;
    /**
     * The Remark
     * @var string
     */
    public $Remark;
    /**
     * The GeoLocX
     * @var float
     */
    public $GeoLocX;
    /**
     * The GeoLocY
     * @var float
     */
    public $GeoLocY;
    /**
     * Constructor method for ParcelStatus
     * @uses ParcelStatus::setParcelNumber()
     * @uses ParcelStatus::setDate()
     * @uses ParcelStatus::setTime()
     * @uses ParcelStatus::setStatus()
     * @uses ParcelStatus::setStatusCodeX()
     * @uses ParcelStatus::setCenter()
     * @uses ParcelStatus::setRemark()
     * @uses ParcelStatus::setGeoLocX()
     * @uses ParcelStatus::setGeoLocY()
     * @param string $parcelNumber
     * @param string $date
     * @param string $time
     * @param string $status
     * @param int $statusCodeX
     * @param string $center
     * @param string $remark
     * @param float $geoLocX
     * @param float $geoLocY
     */
    public function __construct($parcelNumber = null, $date = null, $time = null, $status = null, $statusCodeX = null, $center = null, $remark = null, $geoLocX = null, $geoLocY = null)
    {
        $this
            ->setParcelNumber($parcelNumber)
            ->setDate($date)
            ->setTime($time)
            ->setStatus($status)
            ->setStatusCodeX($statusCodeX)
            ->setCenter($center)
            ->setRemark($remark)
            ->setGeoLocX($geoLocX)
            ->setGeoLocY($geoLocY);
    }
    /**
     * Get ParcelNumber value
     * @return string|null
     */
    public function getParcelNumber()
    {
        return $this->ParcelNumber;
    }
    /**
     * Set ParcelNumber value
     * @param string $parcelNumber
     * @return \ups_sk\StructType\ParcelStatus
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelNumber) && !is_string($parcelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->ParcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \ups_sk\StructType\ParcelStatus
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \ups_sk\StructType\ParcelStatus
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \ups_sk\StructType\ParcelStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCodeX value
     * @return int|null
     */
    public function getStatusCodeX()
    {
        return $this->StatusCodeX;
    }
    /**
     * Set StatusCodeX value
     * @param int $statusCodeX
     * @return \ups_sk\StructType\ParcelStatus
     */
    public function setStatusCodeX($statusCodeX = null)
    {
        // validation for constraint: int
        if (!is_null($statusCodeX) && !(is_int($statusCodeX) || ctype_digit($statusCodeX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCodeX, true), gettype($statusCodeX)), __LINE__);
        }
        $this->StatusCodeX = $statusCodeX;
        return $this;
    }
    /**
     * Get Center value
     * @return string|null
     */
    public function getCenter()
    {
        return $this->Center;
    }
    /**
     * Set Center value
     * @param string $center
     * @return \ups_sk\StructType\ParcelStatus
     */
    public function setCenter($center = null)
    {
        // validation for constraint: string
        if (!is_null($center) && !is_string($center)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($center, true), gettype($center)), __LINE__);
        }
        $this->Center = $center;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \ups_sk\StructType\ParcelStatus
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get GeoLocX value
     * @return float|null
     */
    public function getGeoLocX()
    {
        return $this->GeoLocX;
    }
    /**
     * Set GeoLocX value
     * @param float $geoLocX
     * @return \ups_sk\StructType\ParcelStatus
     */
    public function setGeoLocX($geoLocX = null)
    {
        // validation for constraint: float
        if (!is_null($geoLocX) && !(is_float($geoLocX) || is_numeric($geoLocX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($geoLocX, true), gettype($geoLocX)), __LINE__);
        }
        $this->GeoLocX = $geoLocX;
        return $this;
    }
    /**
     * Get GeoLocY value
     * @return float|null
     */
    public function getGeoLocY()
    {
        return $this->GeoLocY;
    }
    /**
     * Set GeoLocY value
     * @param float $geoLocY
     * @return \ups_sk\StructType\ParcelStatus
     */
    public function setGeoLocY($geoLocY = null)
    {
        // validation for constraint: float
        if (!is_null($geoLocY) && !(is_float($geoLocY) || is_numeric($geoLocY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($geoLocY, true), gettype($geoLocY)), __LINE__);
        }
        $this->GeoLocY = $geoLocY;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ups_sk\StructType\ParcelStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
