<?php

namespace ups_sk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Parcel StructType
 * @subpackage Structs
 */
class Parcel extends AbstractStructBase
{
    /**
     * The ParcelNumber
     * @var string
     */
    public $ParcelNumber;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * @var int
     */
    public $StatusCode;
    /**
     * The ReferenceNumber1
     * @var string
     */
    public $ReferenceNumber1;
    /**
     * The ReferenceNumber2
     * @var string
     */
    public $ReferenceNumber2;
    /**
     * The ReferenceNumber3
     * @var string
     */
    public $ReferenceNumber3;
    /**
     * The ReferenceNumber4
     * @var string
     */
    public $ReferenceNumber4;
    /**
     * The Barcode
     * @var string
     */
    public $Barcode;
    /**
     * The InternationalReferenceNumber
     * @var string
     */
    public $InternationalReferenceNumber;
    /**
     * Constructor method for Parcel
     * @uses Parcel::setParcelNumber()
     * @uses Parcel::setStatus()
     * @uses Parcel::setStatusCode()
     * @uses Parcel::setReferenceNumber1()
     * @uses Parcel::setReferenceNumber2()
     * @uses Parcel::setReferenceNumber3()
     * @uses Parcel::setReferenceNumber4()
     * @uses Parcel::setBarcode()
     * @uses Parcel::setInternationalReferenceNumber()
     * @param string $parcelNumber
     * @param string $status
     * @param int $statusCode
     * @param string $referenceNumber1
     * @param string $referenceNumber2
     * @param string $referenceNumber3
     * @param string $referenceNumber4
     * @param string $barcode
     * @param string $internationalReferenceNumber
     */
    public function __construct($parcelNumber = null, $status = null, $statusCode = null, $referenceNumber1 = null, $referenceNumber2 = null, $referenceNumber3 = null, $referenceNumber4 = null, $barcode = null, $internationalReferenceNumber = null)
    {
        $this
            ->setParcelNumber($parcelNumber)
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setReferenceNumber1($referenceNumber1)
            ->setReferenceNumber2($referenceNumber2)
            ->setReferenceNumber3($referenceNumber3)
            ->setReferenceNumber4($referenceNumber4)
            ->setBarcode($barcode)
            ->setInternationalReferenceNumber($internationalReferenceNumber);
    }
    /**
     * Get ParcelNumber value
     * @return string|null
     */
    public function getParcelNumber()
    {
        return $this->ParcelNumber;
    }
    /**
     * Set ParcelNumber value
     * @param string $parcelNumber
     * @return \ups_sk\StructType\Parcel
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelNumber) && !is_string($parcelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->ParcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \ups_sk\StructType\Parcel
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \ups_sk\StructType\Parcel
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get ReferenceNumber1 value
     * @return string|null
     */
    public function getReferenceNumber1()
    {
        return $this->ReferenceNumber1;
    }
    /**
     * Set ReferenceNumber1 value
     * @param string $referenceNumber1
     * @return \ups_sk\StructType\Parcel
     */
    public function setReferenceNumber1($referenceNumber1 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber1) && !is_string($referenceNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber1, true), gettype($referenceNumber1)), __LINE__);
        }
        $this->ReferenceNumber1 = $referenceNumber1;
        return $this;
    }
    /**
     * Get ReferenceNumber2 value
     * @return string|null
     */
    public function getReferenceNumber2()
    {
        return $this->ReferenceNumber2;
    }
    /**
     * Set ReferenceNumber2 value
     * @param string $referenceNumber2
     * @return \ups_sk\StructType\Parcel
     */
    public function setReferenceNumber2($referenceNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber2) && !is_string($referenceNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber2, true), gettype($referenceNumber2)), __LINE__);
        }
        $this->ReferenceNumber2 = $referenceNumber2;
        return $this;
    }
    /**
     * Get ReferenceNumber3 value
     * @return string|null
     */
    public function getReferenceNumber3()
    {
        return $this->ReferenceNumber3;
    }
    /**
     * Set ReferenceNumber3 value
     * @param string $referenceNumber3
     * @return \ups_sk\StructType\Parcel
     */
    public function setReferenceNumber3($referenceNumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber3) && !is_string($referenceNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber3, true), gettype($referenceNumber3)), __LINE__);
        }
        $this->ReferenceNumber3 = $referenceNumber3;
        return $this;
    }
    /**
     * Get ReferenceNumber4 value
     * @return string|null
     */
    public function getReferenceNumber4()
    {
        return $this->ReferenceNumber4;
    }
    /**
     * Set ReferenceNumber4 value
     * @param string $referenceNumber4
     * @return \ups_sk\StructType\Parcel
     */
    public function setReferenceNumber4($referenceNumber4 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber4) && !is_string($referenceNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber4, true), gettype($referenceNumber4)), __LINE__);
        }
        $this->ReferenceNumber4 = $referenceNumber4;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \ups_sk\StructType\Parcel
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get InternationalReferenceNumber value
     * @return string|null
     */
    public function getInternationalReferenceNumber()
    {
        return $this->InternationalReferenceNumber;
    }
    /**
     * Set InternationalReferenceNumber value
     * @param string $internationalReferenceNumber
     * @return \ups_sk\StructType\Parcel
     */
    public function setInternationalReferenceNumber($internationalReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($internationalReferenceNumber) && !is_string($internationalReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalReferenceNumber, true), gettype($internationalReferenceNumber)), __LINE__);
        }
        $this->InternationalReferenceNumber = $internationalReferenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ups_sk\StructType\Parcel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
