<?php

namespace ups_sk\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getTest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return void|bool
     */
    public function getTest()
    {
        try {
            $this->setResult($this->getSoapClient()->getTest());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getListOfShipments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $kundenr
     * @param string $verknr
     * @param string $km_mandr
     * @param string $versdat
     * @param string $langi
     * @return \ups_sk\StructType\Shipment[]|bool
     */
    public function getListOfShipments($kundenr, $verknr, $km_mandr, $versdat, $langi)
    {
        try {
            $this->setResult($this->getSoapClient()->getListOfShipments($kundenr, $verknr, $km_mandr, $versdat, $langi));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $landnr
     * @param string $mandnr
     * @param string $lfdnr
     * @param string $langi
     * @return \ups_sk\StructType\Shipment|bool
     */
    public function getShipment($landnr, $mandnr, $lfdnr, $langi)
    {
        try {
            $this->setResult($this->getSoapClient()->getShipment($landnr, $mandnr, $lfdnr, $langi));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getListOfParcels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $landnr
     * @param string $mandnr
     * @param string $lfdnr
     * @param string $langi
     * @return \ups_sk\StructType\Parcel[]|bool
     */
    public function getListOfParcels($landnr, $mandnr, $lfdnr, $langi)
    {
        try {
            $this->setResult($this->getSoapClient()->getListOfParcels($landnr, $mandnr, $lfdnr, $langi));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getParcelStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $landnr
     * @param string $mandnr
     * @param string $lfdnr
     * @param string $langi
     * @return \ups_sk\StructType\ParcelStatus[]|bool
     */
    public function getParcelStatus($landnr, $mandnr, $lfdnr, $langi)
    {
        try {
            $this->setResult($this->getSoapClient()->getParcelStatus($landnr, $mandnr, $lfdnr, $langi));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void|\ups_sk\StructType\ParcelStatus[]|\ups_sk\StructType\Parcel[]|\ups_sk\StructType\Shipment|\ups_sk\StructType\Shipment[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
