<?php

namespace ups_sk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The ShipmentNumber
     * @var string
     */
    public $ShipmentNumber;
    /**
     * The ShippingDate
     * @var string
     */
    public $ShippingDate;
    /**
     * The DestinationZip
     * @var string
     */
    public $DestinationZip;
    /**
     * The Shipper
     * @var string
     */
    public $Shipper;
    /**
     * The Receiver
     * @var string
     */
    public $Receiver;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * @var int
     */
    public $StatusCode;
    /**
     * The NameOfReceiver
     * @var string
     */
    public $NameOfReceiver;
    /**
     * The ReferenceNumber1
     * @var string
     */
    public $ReferenceNumber1;
    /**
     * The ReferenceNumber2
     * @var string
     */
    public $ReferenceNumber2;
    /**
     * The ReferenceNumber3
     * @var string
     */
    public $ReferenceNumber3;
    /**
     * The ReferenceNumber4
     * @var string
     */
    public $ReferenceNumber4;
    /**
     * The Barcode
     * @var string
     */
    public $Barcode;
    /**
     * The InternationalReferenceNumber
     * @var string
     */
    public $InternationalReferenceNumber;
    /**
     * The Weight
     * @var float
     */
    public $Weight;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setShipmentNumber()
     * @uses Shipment::setShippingDate()
     * @uses Shipment::setDestinationZip()
     * @uses Shipment::setShipper()
     * @uses Shipment::setReceiver()
     * @uses Shipment::setStatus()
     * @uses Shipment::setStatusCode()
     * @uses Shipment::setNameOfReceiver()
     * @uses Shipment::setReferenceNumber1()
     * @uses Shipment::setReferenceNumber2()
     * @uses Shipment::setReferenceNumber3()
     * @uses Shipment::setReferenceNumber4()
     * @uses Shipment::setBarcode()
     * @uses Shipment::setInternationalReferenceNumber()
     * @uses Shipment::setWeight()
     * @param string $shipmentNumber
     * @param string $shippingDate
     * @param string $destinationZip
     * @param string $shipper
     * @param string $receiver
     * @param string $status
     * @param int $statusCode
     * @param string $nameOfReceiver
     * @param string $referenceNumber1
     * @param string $referenceNumber2
     * @param string $referenceNumber3
     * @param string $referenceNumber4
     * @param string $barcode
     * @param string $internationalReferenceNumber
     * @param float $weight
     */
    public function __construct($shipmentNumber = null, $shippingDate = null, $destinationZip = null, $shipper = null, $receiver = null, $status = null, $statusCode = null, $nameOfReceiver = null, $referenceNumber1 = null, $referenceNumber2 = null, $referenceNumber3 = null, $referenceNumber4 = null, $barcode = null, $internationalReferenceNumber = null, $weight = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setShippingDate($shippingDate)
            ->setDestinationZip($destinationZip)
            ->setShipper($shipper)
            ->setReceiver($receiver)
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setNameOfReceiver($nameOfReceiver)
            ->setReferenceNumber1($referenceNumber1)
            ->setReferenceNumber2($referenceNumber2)
            ->setReferenceNumber3($referenceNumber3)
            ->setReferenceNumber4($referenceNumber4)
            ->setBarcode($barcode)
            ->setInternationalReferenceNumber($internationalReferenceNumber)
            ->setWeight($weight);
    }
    /**
     * Get ShipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param string $shipmentNumber
     * @return \ups_sk\StructType\Shipment
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get ShippingDate value
     * @return string|null
     */
    public function getShippingDate()
    {
        return $this->ShippingDate;
    }
    /**
     * Set ShippingDate value
     * @param string $shippingDate
     * @return \ups_sk\StructType\Shipment
     */
    public function setShippingDate($shippingDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDate) && !is_string($shippingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingDate, true), gettype($shippingDate)), __LINE__);
        }
        $this->ShippingDate = $shippingDate;
        return $this;
    }
    /**
     * Get DestinationZip value
     * @return string|null
     */
    public function getDestinationZip()
    {
        return $this->DestinationZip;
    }
    /**
     * Set DestinationZip value
     * @param string $destinationZip
     * @return \ups_sk\StructType\Shipment
     */
    public function setDestinationZip($destinationZip = null)
    {
        // validation for constraint: string
        if (!is_null($destinationZip) && !is_string($destinationZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationZip, true), gettype($destinationZip)), __LINE__);
        }
        $this->DestinationZip = $destinationZip;
        return $this;
    }
    /**
     * Get Shipper value
     * @return string|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param string $shipper
     * @return \ups_sk\StructType\Shipment
     */
    public function setShipper($shipper = null)
    {
        // validation for constraint: string
        if (!is_null($shipper) && !is_string($shipper)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipper, true), gettype($shipper)), __LINE__);
        }
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get Receiver value
     * @return string|null
     */
    public function getReceiver()
    {
        return $this->Receiver;
    }
    /**
     * Set Receiver value
     * @param string $receiver
     * @return \ups_sk\StructType\Shipment
     */
    public function setReceiver($receiver = null)
    {
        // validation for constraint: string
        if (!is_null($receiver) && !is_string($receiver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiver, true), gettype($receiver)), __LINE__);
        }
        $this->Receiver = $receiver;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \ups_sk\StructType\Shipment
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \ups_sk\StructType\Shipment
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get NameOfReceiver value
     * @return string|null
     */
    public function getNameOfReceiver()
    {
        return $this->NameOfReceiver;
    }
    /**
     * Set NameOfReceiver value
     * @param string $nameOfReceiver
     * @return \ups_sk\StructType\Shipment
     */
    public function setNameOfReceiver($nameOfReceiver = null)
    {
        // validation for constraint: string
        if (!is_null($nameOfReceiver) && !is_string($nameOfReceiver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOfReceiver, true), gettype($nameOfReceiver)), __LINE__);
        }
        $this->NameOfReceiver = $nameOfReceiver;
        return $this;
    }
    /**
     * Get ReferenceNumber1 value
     * @return string|null
     */
    public function getReferenceNumber1()
    {
        return $this->ReferenceNumber1;
    }
    /**
     * Set ReferenceNumber1 value
     * @param string $referenceNumber1
     * @return \ups_sk\StructType\Shipment
     */
    public function setReferenceNumber1($referenceNumber1 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber1) && !is_string($referenceNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber1, true), gettype($referenceNumber1)), __LINE__);
        }
        $this->ReferenceNumber1 = $referenceNumber1;
        return $this;
    }
    /**
     * Get ReferenceNumber2 value
     * @return string|null
     */
    public function getReferenceNumber2()
    {
        return $this->ReferenceNumber2;
    }
    /**
     * Set ReferenceNumber2 value
     * @param string $referenceNumber2
     * @return \ups_sk\StructType\Shipment
     */
    public function setReferenceNumber2($referenceNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber2) && !is_string($referenceNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber2, true), gettype($referenceNumber2)), __LINE__);
        }
        $this->ReferenceNumber2 = $referenceNumber2;
        return $this;
    }
    /**
     * Get ReferenceNumber3 value
     * @return string|null
     */
    public function getReferenceNumber3()
    {
        return $this->ReferenceNumber3;
    }
    /**
     * Set ReferenceNumber3 value
     * @param string $referenceNumber3
     * @return \ups_sk\StructType\Shipment
     */
    public function setReferenceNumber3($referenceNumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber3) && !is_string($referenceNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber3, true), gettype($referenceNumber3)), __LINE__);
        }
        $this->ReferenceNumber3 = $referenceNumber3;
        return $this;
    }
    /**
     * Get ReferenceNumber4 value
     * @return string|null
     */
    public function getReferenceNumber4()
    {
        return $this->ReferenceNumber4;
    }
    /**
     * Set ReferenceNumber4 value
     * @param string $referenceNumber4
     * @return \ups_sk\StructType\Shipment
     */
    public function setReferenceNumber4($referenceNumber4 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber4) && !is_string($referenceNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber4, true), gettype($referenceNumber4)), __LINE__);
        }
        $this->ReferenceNumber4 = $referenceNumber4;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \ups_sk\StructType\Shipment
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get InternationalReferenceNumber value
     * @return string|null
     */
    public function getInternationalReferenceNumber()
    {
        return $this->InternationalReferenceNumber;
    }
    /**
     * Set InternationalReferenceNumber value
     * @param string $internationalReferenceNumber
     * @return \ups_sk\StructType\Shipment
     */
    public function setInternationalReferenceNumber($internationalReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($internationalReferenceNumber) && !is_string($internationalReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalReferenceNumber, true), gettype($internationalReferenceNumber)), __LINE__);
        }
        $this->InternationalReferenceNumber = $internationalReferenceNumber;
        return $this;
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \ups_sk\StructType\Shipment
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ups_sk\StructType\Shipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
