<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ZK ServiceType
 * @subpackage Services
 */
class ZK extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ZKwfGetStatusFromId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZKwfGetStatusFromId $parameters
     * @return \StructType\ZKwfGetStatusFromIdResponse|bool
     */
    public function ZKwfGetStatusFromId(\StructType\ZKwfGetStatusFromId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ZKwfGetStatusFromId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ZKwfGetStatusFromIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
